package com.jz.jar.media.service;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoCoursePackRepository;
import com.jz.jooq.media.tables.pojos.TomatoCoursePack;
import com.jz.jooq.media.tables.pojos.TomatoCoursePackVideo;

@Lazy
@Service
public class TomatoCoursePackService {

	@Autowired
	private TomatoCoursePackRepository tomatoCoursePackRepository;

	public TomatoCoursePack getOnlinePack(String pid) {
		return tomatoCoursePackRepository.getOnlinePack(pid);
	}

	public List<TomatoCoursePack> mutiGetOnlinePack(Collection<String> pids) {
		return tomatoCoursePackRepository.mutiGetOnlinePack(pids);
	}

	public List<TomatoCoursePackVideo> getPackVideos(String pid) {
		return tomatoCoursePackRepository.getPackVideos(pid);
	}

	public void increStudyCnt(String pid, int num) {
		tomatoCoursePackRepository.increStudyCnt(pid, num);
	}

	public TomatoCoursePackVideo getPackVideo(String wid, String pid) {
		return tomatoCoursePackRepository.getPackVideo(wid, pid);
	}

}
