/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.jz.jar.media.enums.AuditStatus;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.WorksInfo;
import com.jz.jooq.media.tables.WorksTheme;
import com.jz.jooq.media.tables.WorksThemeRelation;
import java.util.Collection;
import java.util.List;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class WorksThemeRepository
extends MediaBaseRepository {
    private static final WorksTheme WT = Tables.WORKS_THEME;
    private static final WorksThemeRelation TR = Tables.WORKS_THEME_RELATION;
    private static final WorksInfo WI = Tables.WORKS_INFO;

    public List<com.jz.jooq.media.tables.pojos.WorksTheme> findSimpleOnlineTheme() {
        return this.mediaCtx.select((SelectField)WorksThemeRepository.WT.ID, (SelectField)WorksThemeRepository.WT.SEQ, (SelectField)WorksThemeRepository.WT.LAST_UPDATED).from((TableLike)WT).where(new Condition[]{WorksThemeRepository.WT.STATUS.eq((Object)AuditStatus.online.getCode())}).fetchInto(com.jz.jooq.media.tables.pojos.WorksTheme.class);
    }

    public int countOnlineTheme() {
        return this.mediaCtx.fetchCount((Table)WT, WorksThemeRepository.WT.STATUS.eq((Object)AuditStatus.online.getCode()));
    }

    public List<String> findOnlineThemeIds(int start, int size) {
        return this.mediaCtx.select((SelectField)WorksThemeRepository.WT.ID).from((TableLike)WT).where(new Condition[]{WorksThemeRepository.WT.STATUS.eq((Object)AuditStatus.online.getCode())}).orderBy(WorksThemeRepository.WT.SEQ.desc(), WorksThemeRepository.WT.LAST_UPDATED.desc()).limit(start, size).fetchInto(String.class);
    }

    public List<com.jz.jooq.media.tables.pojos.WorksTheme> findThemeInfo(Collection<String> tids) {
        return this.mediaCtx.selectFrom((Table)WT).where(new Condition[]{WorksThemeRepository.WT.ID.in(tids)}).orderBy(WorksThemeRepository.WT.ID.sortAsc(tids)).fetchInto(com.jz.jooq.media.tables.pojos.WorksTheme.class);
    }

    public List<String> filterRevealableThemeIds(Collection<String> tids) {
        return this.mediaCtx.selectDistinct((SelectField)WorksThemeRepository.TR.THEME_ID).from((TableLike)TR.join((TableLike)WI).on(new Condition[]{WorksThemeRepository.TR.WORK_ID.eq((Field)WorksThemeRepository.WI.ID)})).where(new Condition[]{WorksThemeRepository.TR.THEME_ID.in(tids).and(WorksThemeRepository.WI.IS_OPEN.ge((Object)1)).and(WorksThemeRepository.WI.STATUS.eq((Object)AuditStatus.online.getCode()))}).fetchInto(String.class);
    }

    public List<String> getWorkIdForThemeId(String tid) {
        return this.mediaCtx.select((SelectField)WorksThemeRepository.TR.WORK_ID).from((TableLike)TR).where(new Condition[]{WorksThemeRepository.TR.THEME_ID.eq((Object)tid)}).fetchInto(String.class);
    }
}

