package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.TomatoThemeRepository;
import com.jz.jooq.media.tables.pojos.TomatoTheme;

@Lazy
@Service
public class TomatoThemeService {

	@Autowired
	private TomatoThemeRepository tomatoThemeRepository;

	public List<String> findAllOnlineThemeIds() {
		return tomatoThemeRepository.findAllOnlineThemeIds();
	}

	public int countOnlineThemes() {
		return tomatoThemeRepository.countOnlineThemes();
	}

	public List<TomatoTheme> findOnlineThemes(int start, int size) {
		return tomatoThemeRepository.findOnlineThemes(start, size);
	}

	public boolean isOnlineTheme(String id) {
		return tomatoThemeRepository.isOnlineTheme(id);
	}
}
