package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.UploadVideoScore;

@Lazy
@Repository
public class UploadVideoScoreRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.UploadVideoScore UVS = Tables.UPLOAD_VIDEO_SCORE;

	public List<UploadVideoScore> mutiGetVideoScores(Collection<String> wids) {
		return mediaCtx.selectFrom(UVS).where(UVS.WID.in(wids)).fetchInto(UploadVideoScore.class);
	}

	public void createScore(String wid, String schoolId, String teacherId, int score, String remark) {
		mediaCtx.insertInto(UVS, UVS.WID, UVS.SCHOOL_ID, UVS.TEACHER_ID, UVS.SCORE, UVS.REMARK, UVS.CREATE_TIME)
				.values(wid, schoolId, teacherId, score, remark, System.currentTimeMillis()).onDuplicateKeyIgnore()
				.execute();
	}

	public UploadVideoScore getVideoScore(String wid) {
		return mediaCtx.selectFrom(UVS).where(UVS.WID.eq(wid)).fetchAnyInto(UploadVideoScore.class);
	}
}
