package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PlaylistVideo;
import com.jz.jooq.media.tables.records.PlaylistVideoRecord;

@Lazy
@Repository
public class PlaylistVideoRepository extends MediaBaseRepository
		implements BaseConditionRepository<PlaylistVideoRecord> {

	private static final com.jz.jooq.media.tables.PlaylistVideo PV = Tables.PLAYLIST_VIDEO;

	public List<String> findWids(String pid) {
		return mediaCtx.select(PV.WID).from(PV).where(PV.PID.eq(pid)).orderBy(PV.SEQ).fetchInto(String.class);
	}

	public List<String> findWids(String pid, int start, int size) {
		return mediaCtx.select(PV.WID).from(PV).where(PV.PID.eq(pid)).orderBy(PV.SEQ).limit(start, size)
				.fetchInto(String.class);
	}

	public int countWids(String pid) {
		return mediaCtx.fetchCount(PV, PV.PID.eq(pid));
	}

	public List<PlaylistVideo> getVideos(Map<String, Collection<Integer>> pid2Times) {
		return mediaCtx.selectFrom(PV).where(getOrWhereCondition(PV.PID, PV.SEQ, pid2Times))
				.fetchInto(PlaylistVideo.class);
	}

}
