/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.common.redis.auto.cache.annotation.definition.THashCache;
import com.jz.common.redis.auto.cache.annotation.types.hash.THash;
import com.jz.jar.media.repository.PlaylistRepository;
import com.jz.jooq.media.tables.pojos.Playlist;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
@THashCache(clazz=Playlist.class, keyFieldName="pid", keyPrefix="playlist:")
public class PlaylistService {
    @Autowired
    private PlaylistRepository playlistRepository;

    @THash(keyArgsIndex=0)
    public Playlist getPlaylist(String pid) {
        return this.playlistRepository.getPlaylist(pid);
    }

    @THash(keyArgsIndex=0)
    public List<Playlist> getPlaylist(Collection<String> pids) {
        return this.playlistRepository.getPlaylist(pids);
    }

    public Map<String, Integer> getPlaylistToVideoCount(Collection<String> pids) {
        return this.playlistRepository.getPlaylistToVideoCount(pids);
    }
}

