/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.repository;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.repository.MediaBaseRepository;
import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.GroupField;
import org.jooq.Result;
import org.jooq.SelectField;
import org.jooq.Table;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Lazy
@Repository
public class PlaylistRelationRepository
extends MediaBaseRepository {
    private static final com.jz.jooq.media.tables.PlaylistRelation PR = Tables.PLAYLIST_RELATION;

    public List<PlaylistRelation> findLevelTopics() {
        return this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.LID, (SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).groupBy(new GroupField[]{PlaylistRelationRepository.PR.LID, PlaylistRelationRepository.PR.CID}).fetchInto(PlaylistRelation.class);
    }

    public List<String> getTopicsForPlaylist(String pid) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.PID.eq((Object)pid)}).fetchInto(String.class);
    }

    public int countPlaylistForLevelAndTopic(String lid, Collection<String> cidArray) {
        return (Integer)this.mediaCtx.select((SelectField)DSL.countDistinct((Field)PlaylistRelationRepository.PR.PID)).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.in(cidArray))}).fetchAnyInto(Integer.TYPE);
    }

    public List<String> findPlaylistForLevelAndTopic(String lid, Collection<String> cidArray, int start, int size) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.PID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.in(cidArray))}).orderBy(PlaylistRelationRepository.PR.PID.asc()).limit(start, size).fetchInto(String.class);
    }

    public boolean isSpecialPlaylist(String lid, String pid) {
        return this.mediaCtx.fetchExists((Table)PR, PlaylistRelationRepository.PR.PID.eq((Object)pid).and(PlaylistRelationRepository.PR.LID.eq((Object)lid)).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1)));
    }

    public Map<String, Integer> findSpecialTopicToCount(String lid) {
        Result result = this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.CID, (SelectField)DSL.count((Field)PlaylistRelationRepository.PR.CID)).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1))}).groupBy(new GroupField[]{PlaylistRelationRepository.PR.CID}).fetch();
        if (null == result || result.isEmpty()) {
            return null;
        }
        HashMap topicToCount = Maps.newHashMap();
        result.forEach(it -> {
            Integer cfr_ignored_0 = (Integer)topicToCount.put(it.value1(), it.value2());
        });
        return topicToCount;
    }

    public int countSpecialPlaylist(String lid, String cid) {
        return this.mediaCtx.fetchCount((Table)PR, PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.eq((Object)cid)).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1)));
    }

    public List<String> findSpecialPlaylist(String lid, String cid) {
        return this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.PID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.eq((Object)cid)).and(PlaylistRelationRepository.PR.IS_SPECIAL.eq((Object)1))}).orderBy(PlaylistRelationRepository.PR.SPECIAL_SEQ.desc()).fetchInto(String.class);
    }

    public List<String> findPlaylistTopic(String lid, Collection<String> pidArray) {
        return this.mediaCtx.selectDistinct((SelectField)PlaylistRelationRepository.PR.CID).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.PID.in(pidArray).and(PlaylistRelationRepository.PR.LID.eq((Object)lid))}).fetchInto(String.class);
    }

    public Map<String, String> findMaxWatchCntPlaylistForCids(String lid, Collection<String> cidArray) {
        Result result = this.mediaCtx.select((SelectField)PlaylistRelationRepository.PR.PID, (SelectField)PlaylistRelationRepository.PR.CID, (SelectField)DSL.max((Field)PlaylistRelationRepository.PR.WATCH_CNT)).from((TableLike)PR).where(new Condition[]{PlaylistRelationRepository.PR.LID.eq((Object)lid).and(PlaylistRelationRepository.PR.CID.in(cidArray))}).groupBy(new GroupField[]{PlaylistRelationRepository.PR.CID}).fetch();
        if (ArrayMapTools.isEmpty((Collection)result)) {
            return Maps.newHashMap();
        }
        HashMap has = Maps.newHashMap();
        result.forEach(it -> {
            String cfr_ignored_0 = (String)has.put(it.value1(), it.value2());
        });
        return has;
    }
}

