package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.jar.media.repository.UserNoticeRepository;
import com.jz.jooq.media.tables.pojos.UserNotice;

@Lazy
@Service
public class UserNoticeService {
	
	@Autowired
	private UserNoticeRepository userNoticeRepository;

	public void save(String uid, String content) {
		userNoticeRepository.save(uid, content);
	}

	public int countNotices(String uid, long timestamp) {
		return userNoticeRepository.countNotices(uid, timestamp);
	}

	public List<UserNotice> findNotices(String uid, int start, int size) {
		return userNoticeRepository.findNotices(uid, start, size);
	}
}
