package com.jz.jar.media.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.redis.auto.cache.annotation.definition.TCache;
import com.jz.common.redis.auto.cache.annotation.types.list.TList;
import com.jz.jar.media.repository.PlaylistVideoRepository;

/**
 * @Title PlaylistVideoService
 * @Package com.jz.jar.media.service
 * @author tangjunfeng
 * @date 2018年8月2日 上午10:15:39
 * @version V1.0
 */
@Lazy
@Service
@TCache(keyPrefix = "playlist:wids:")
public class PlaylistVideoService {

	@Autowired
	private PlaylistVideoRepository playlistVideoRepository;

	@TList(keyArgsIndex = 0)
	public List<String> findWids(String pid) {
		return playlistVideoRepository.findWids(pid);
	}

	public List<String> findWids(String pid, int start, int size) {
		return playlistVideoRepository.findWids(pid, start, size);
	}

	public int countWids(String pid) {
		return playlistVideoRepository.countWids(pid);
	}
}
