package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.SpecialPracticeHistory;

@Lazy
@Repository
public class SpecialPracticeHistoryRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.SpecialPracticeHistory SPH = Tables.SPECIAL_PRACTICE_HISTORY;

	public void saveHistory(String suid, String pid, int targetCnt, int addVideoCnt, String nextWid) {
		long timeMillis = System.currentTimeMillis();
		mediaCtx.insertInto(SPH, SPH.SUID, SPH.PID, SPH.TARGET_CNT, SPH.PLAY_CNT, SPH.NEXT_WID, SPH.LAST_TIME)
				.values(suid, pid, targetCnt, addVideoCnt, nextWid, timeMillis).onDuplicateKeyUpdate()
				.set(SPH.PLAY_CNT, SPH.PLAY_CNT.add(addVideoCnt)).set(SPH.NEXT_WID, nextWid)
				.set(SPH.LAST_TIME, timeMillis).execute();
	}

	public List<SpecialPracticeHistory> getHistoryForPlaylist(String suid, Collection<String> pidArray) {
		return mediaCtx.select(SPH.PID, SPH.TARGET_CNT, SPH.PLAY_CNT).from(SPH)
				.where(SPH.SUID.eq(suid).and(SPH.PID.in(pidArray))).fetchInto(SpecialPracticeHistory.class);
	}
}
