package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class QuizClassifyRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.QuizClassify QC = Tables.QUIZ_CLASSIFY;

	public String getQuizForLidAndWeek(String lid, String week) {
		List<String> quizs = mediaCtx.select(QC.QZID).from(QC).where(QC.LID.eq(lid).and(QC.WEEK.eq(week)))
				.fetchInto(String.class);
		return ArrayMapTools.isEmpty(quizs) ? null : quizs.get(0);
	}
}
