package com.jz.jar.media.repository;

import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;

@Lazy
@Repository
public class PlaylistVideoRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.PlaylistVideo PV = Tables.PLAYLIST_VIDEO;

	public List<String> findWids(String pid) {
		return mediaCtx.select(PV.WID).from(PV).where(PV.PID.eq(pid)).orderBy(PV.SEQ).fetchInto(String.class);
	}

	public List<String> findWids(String pid, int start, int size) {
		return mediaCtx.select(PV.WID).from(PV).where(PV.PID.eq(pid)).orderBy(PV.SEQ).limit(start, size)
				.fetchInto(String.class);
	}

	public int countWids(String pid) {
		return mediaCtx.fetchCount(PV, PV.PID.eq(pid));
	}
}
