package com.jz.jar.media.repository;

import java.util.Collection;
import java.util.List;

import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

import com.jz.jooq.media.Tables;
import com.jz.jooq.media.tables.pojos.CommonPlayHistory;

@Lazy
@Repository
public class CommonPlayHistoryRepository extends MediaBaseRepository {

	private static final com.jz.jooq.media.tables.CommonPlayHistory CPH = Tables.COMMON_PLAY_HISTORY;

	public void save(String commonKey, String pid, String wid) {
		mediaCtx.insertInto(CPH, CPH.COMMON_KEY, CPH.PID, CPH.WID, CPH.CREATE_TIME)
				.values(commonKey, pid, wid, System.currentTimeMillis()).execute();
	}

	public boolean isExist(String commonKey, String pid, String wid) {
		return mediaCtx.fetchExists(CPH, CPH.COMMON_KEY.eq(commonKey).and(CPH.PID.eq(pid)).and(CPH.WID.eq(wid)));
	}

	public List<CommonPlayHistory> findPlayHistories(String commonKey, Collection<String> pidArray) {
		return mediaCtx.selectFrom(CPH).where(CPH.COMMON_KEY.eq(commonKey).and(CPH.PID.in(pidArray)))
				.fetchInto(CommonPlayHistory.class);
	}
}
