/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.service;

import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.repository.CommonPlayHistoryRepository;
import com.jz.jooq.media.tables.pojos.CommonPlayHistory;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class CommonPlayHistoryService {
    private static final SimpleDateFormat yearMonthDay = new SimpleDateFormat("yyyyMMdd");
    @Autowired
    private CommonPlayHistoryRepository commonPlayHistoryRepository;

    public void save(String commonKey, String pid, String wid) {
        this.commonPlayHistoryRepository.save(commonKey, pid, wid);
    }

    public boolean isExist(String commonKey, String pid, String wid) {
        return this.commonPlayHistoryRepository.isExist(commonKey, pid, wid);
    }

    public List<CommonPlayHistory> findPlayHistories(String commonKey, Collection<String> pidArray) {
        return this.commonPlayHistoryRepository.findPlayHistories(commonKey, pidArray);
    }

    public String getCommonKey(String suid, DbField field) {
        if (DbField.special == field) {
            return "zxlx:" + suid;
        }
        if (DbField.everday == field) {
            return yearMonthDay.format(Calendar.getInstance().getTime()) + ":" + suid;
        }
        return null;
    }
}

