package com.jz.jar.media.wrapper;

import com.jz.jooq.media.tables.pojos.UserNotice;

/**
 * @Title UserNoticeWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年8月9日 下午4:54:26
 * @version V1.0
 */
public class UserNoticeWrapper {
	private UserNoticeWrapper() {
	}

	private Integer id;
	private String title;
	private String content;
	private String colorCtx;
	private Long createTime;
	private Boolean isRead;

	private UserWrapper user;
	private ArtInfoWrapper art;

	public static UserNoticeWrapper of() {
		return new UserNoticeWrapper();
	}

	public static UserNoticeWrapper of(UserNotice notice, long readTime) {
		return new UserNoticeWrapper().setId(notice.getId()).setTitle(notice.getTitle()).setContent(notice.getContent())
				.setColorCtx(notice.getColorCtx()).setCreateTime(notice.getCreated())
				.setIsRead(readTime >= notice.getCreated());
	}

	public Integer getId() {
		return id;
	}

	public UserNoticeWrapper setId(Integer id) {
		this.id = id;
		return this;
	}

	public String getContent() {
		return content;
	}

	public UserNoticeWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public Long getCreateTime() {
		return createTime;
	}

	public UserNoticeWrapper setCreateTime(Long createTime) {
		this.createTime = createTime;
		return this;
	}

	public Boolean getIsRead() {
		return isRead;
	}

	public UserNoticeWrapper setIsRead(Boolean isRead) {
		this.isRead = isRead;
		return this;
	}

	public UserWrapper getUser() {
		return user;
	}

	public UserNoticeWrapper setUser(UserWrapper user) {
		this.user = user;
		return this;
	}

	public ArtInfoWrapper getArt() {
		return art;
	}

	public UserNoticeWrapper setArt(ArtInfoWrapper art) {
		this.art = art;
		return this;
	}

	public String getTitle() {
		return title;
	}

	public UserNoticeWrapper setTitle(String title) {
		this.title = title;
		return this;
	}

	public String getColorCtx() {
		return colorCtx;
	}

	public UserNoticeWrapper setColorCtx(String colorCtx) {
		this.colorCtx = colorCtx;
		return this;
	}

}
