package com.jz.jar.media.request;

import java.util.Collection;

public class ArtRequest {
	private ArtRequest() {
	}

	private String artId;
	private Collection<String> artIds;
	private String uid;

	private Boolean withStudent = false;

	public static ArtRequest of(String uid, String artId) {
		return new ArtRequest().setArtId(artId).setUid(uid);
	}

	public static ArtRequest of(Collection<String> artIds) {
		return new ArtRequest().setArtIds(artIds);
	}

	public static ArtRequest of(String uid, Collection<String> artIds) {
		return of(artIds).setUid(uid);
	}

	public String getArtId() {
		return artId;
	}

	public ArtRequest setArtId(String artId) {
		this.artId = artId;
		return this;
	}

	public Collection<String> getArtIds() {
		return artIds;
	}

	public ArtRequest setArtIds(Collection<String> artIds) {
		this.artIds = artIds;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public ArtRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public Boolean getWithStudent() {
		return withStudent;
	}

	public ArtRequest setWithStudent(Boolean withStudent) {
		this.withStudent = withStudent;
		return this;
	}

}
