package com.jz.jar.media.request;

import java.util.Collection;

/**
 * @Title PlaylistRequest
 * @Package com.jz.jar.media.request
 * @author tangjunfeng
 * @date 2018年8月3日 下午5:31:36
 * @version V1.0
 */
public class PlaylistRequest {
	private PlaylistRequest() {
	}

	private String pid;
	private Collection<String> pids;
	private String uid;
	private String suid;

	private Boolean isCollect;
	private Boolean isRecomm;
	private Boolean isSpecial;
	private Boolean isEverday;

	private Boolean withNextVideo = false;

	public static PlaylistRequest of(String pid) {
		return new PlaylistRequest().setPid(pid);
	}

	public static PlaylistRequest of(String uid, String pid) {
		return of(pid).setUid(uid);
	}

	public static PlaylistRequest of(String uid, String pid, boolean isRecomm) {
		return of(uid, pid).setIsRecomm(isRecomm);
	}

	public static PlaylistRequest of(String uid, String pid, boolean isRecomm, boolean isCollect) {
		return of(uid, pid, isRecomm).setIsCollect(isCollect);
	}

	public static PlaylistRequest of(Collection<String> pids) {
		return new PlaylistRequest().setPids(pids);
	}

	public static PlaylistRequest of(String uid, Collection<String> pids) {
		return of(pids).setUid(uid);
	}

	public static PlaylistRequest of(String uid, Collection<String> pids, boolean isRecomm) {
		return of(uid, pids).setIsRecomm(isRecomm);
	}

	public static PlaylistRequest of(String uid, Collection<String> pids, boolean isRecomm, boolean isCollect) {
		return of(uid, pids, isRecomm).setIsCollect(isCollect);
	}

	public String getPid() {
		return pid;
	}

	public PlaylistRequest setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public Collection<String> getPids() {
		return pids;
	}

	public PlaylistRequest setPids(Collection<String> pids) {
		this.pids = pids;
		return this;
	}

	public String getUid() {
		return uid;
	}

	public PlaylistRequest setUid(String uid) {
		this.uid = uid;
		return this;
	}

	public String getSuid() {
		return suid;
	}

	public PlaylistRequest setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistRequest setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Boolean getIsRecomm() {
		return isRecomm;
	}

	public PlaylistRequest setIsRecomm(Boolean isRecomm) {
		this.isRecomm = isRecomm;
		return this;
	}

	public Boolean getIsSpecial() {
		return isSpecial;
	}

	public PlaylistRequest setIsSpecial(Boolean isSpecial) {
		this.isSpecial = isSpecial;
		return this;
	}

	public Boolean getIsEverday() {
		return isEverday;
	}

	public PlaylistRequest setIsEverday(Boolean isEverday) {
		this.isEverday = isEverday;
		return this;
	}

	public Boolean getWithNextVideo() {
		return withNextVideo;
	}

	public PlaylistRequest setWithNextVideo(Boolean withNextVideo) {
		this.withNextVideo = withNextVideo;
		return this;
	}

}
