package com.jz.jar.media.common;

import com.jz.jar.media.wrapper.ArtInfoWrapper;
import com.jz.jar.media.wrapper.CommentWrapper;
import com.jz.jar.media.wrapper.LessonFeedbackWrapper;
import com.jz.jar.media.wrapper.LessonWrapper;
import com.jz.jar.media.wrapper.LevelWrapper;
import com.jz.jar.media.wrapper.PlaylistWrapper;
import com.jz.jar.media.wrapper.TopicWrapper;
import com.jz.jar.media.wrapper.UserNoticeWrapper;
import com.jz.jar.media.wrapper.VideoWrapper;

/**
 * @Title ItemCard
 * @Package com.jz.jar.media.common
 * @author tangjunfeng
 * @date 2018年8月3日 下午6:35:46
 * @version V1.0
 */
public class ItemCard {
	private ItemCard() {
	}

	private ItemCard(CardType type) {
		this.type = type;
	}

	private CardType type;

	private VideoWrapper video;
	private PlaylistWrapper playlist;
	private LevelWrapper level;
	private TopicWrapper topic;
	private UserNoticeWrapper notice;
	private LessonWrapper lesson;
	private LessonFeedbackWrapper lessonFb;
	private CommentWrapper comment;
	private ArtInfoWrapper art;

	public static ItemCard of() {
		return new ItemCard();
	}

	public static ItemCard of(VideoWrapper video) {
		return new ItemCard(CardType.video).setVideo(video);
	}

	public static ItemCard of(PlaylistWrapper playlist) {
		return new ItemCard(CardType.playlist).setPlaylist(playlist);
	}

	public static ItemCard of(LevelWrapper level) {
		return new ItemCard(CardType.level).setLevel(level);
	}

	public static ItemCard of(TopicWrapper topic) {
		return new ItemCard(CardType.topic).setTopic(topic);
	}

	public static ItemCard of(UserNoticeWrapper notice) {
		return new ItemCard(CardType.notice).setNotice(notice);
	}

	public static ItemCard of(LessonWrapper lesson) {
		return new ItemCard(CardType.lesson).setLesson(lesson);
	}

	public static ItemCard of(LessonFeedbackWrapper lessonFb) {
		return new ItemCard(CardType.lessonFb).setLessonFb(lessonFb);
	}
	
	public static ItemCard of(CommentWrapper comment) {
		return new ItemCard(CardType.comment).setComment(comment);
	}
	
	public static ItemCard of(ArtInfoWrapper art) {
		return new ItemCard(CardType.art).setArt(art);
	}
	
	public CardType getType() {
		return type;
	}

	public ItemCard setType(CardType type) {
		this.type = type;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public ItemCard setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public ItemCard setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

	public LevelWrapper getLevel() {
		return level;
	}

	public ItemCard setLevel(LevelWrapper level) {
		this.level = level;
		return this;
	}

	public TopicWrapper getTopic() {
		return topic;
	}

	public ItemCard setTopic(TopicWrapper topic) {
		this.topic = topic;
		return this;
	}

	public UserNoticeWrapper getNotice() {
		return notice;
	}

	public ItemCard setNotice(UserNoticeWrapper notice) {
		this.notice = notice;
		return this;
	}

	public LessonWrapper getLesson() {
		return lesson;
	}

	public ItemCard setLesson(LessonWrapper lesson) {
		this.lesson = lesson;
		return this;
	}

	public LessonFeedbackWrapper getLessonFb() {
		return lessonFb;
	}

	public ItemCard setLessonFb(LessonFeedbackWrapper lessonFb) {
		this.lessonFb = lessonFb;
		return this;
	}

	public CommentWrapper getComment() {
		return comment;
	}

	public ItemCard setComment(CommentWrapper comment) {
		this.comment = comment;
		return this;
	}

	public ArtInfoWrapper getArt() {
		return art;
	}

	public ItemCard setArt(ArtInfoWrapper art) {
		this.art = art;
		return this;
	}

}
