package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.service.LevelService;
import com.jz.jooq.media.tables.pojos.Level;

@Lazy
@Service
@EnableScheduling
public class LevelProxy {

	private static final Map<BrandEnum, List<Level>> brand2LevelArray = Maps.newLinkedHashMap();

	@Autowired
	private LevelService levelService;

	/** 加载级别到缓存中 */
	@PostConstruct
	@Scheduled(cron = "0 */5 * * * ?")
	public void loadLevelCache() {
		List<Level> levels = levelService.find();
		if (ArrayMapTools.isEmpty(levels)) {
			return;
		}
		brand2LevelArray.clear();
		levels.forEach(it -> {
			BrandEnum brand = BrandEnum.valueOf(it.getBrand());
			if (!brand2LevelArray.containsKey(brand))
				brand2LevelArray.put(brand, Lists.newArrayList());
			brand2LevelArray.get(brand).add(it);
		});
	}

	public Level getLevelForAge(double age, BrandEnum brand) {
		if (!brand2LevelArray.containsKey(brand))
			return null;
		for (Level le : brand2LevelArray.get(brand)) {
			if (le.getMinAge() <= age && age <= le.getMaxAge()) {
				return le;
			}
		}
		return null;
	}

}
