package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jooq.media.tables.pojos.PlaylistRelation;

/**
 * @Title PlaylistRelationProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月10日 下午4:16:29
 * @version V1.0
 */
@Lazy
@Service
@EnableScheduling
public class PlaylistRelationProxy {

	private static final Map<String, List<String>> cacheLevel2Topics = Maps.newHashMap();
	
	@Autowired
	private PlaylistRelationService playlistRelationService;
	
	/** 加载级别对应分类信息到缓存 */
	@PostConstruct
	@Scheduled(cron = "0 */5 * * * ?")
	public void loadRelationToCache() {
		List<PlaylistRelation> relations = playlistRelationService.findLevelTopics();
		if (ArrayMapTools.isEmpty(relations))
			return;
		Map<String, List<String>> levelToTopics = Maps.newHashMap();
		for (PlaylistRelation r : relations) {
			if (!levelToTopics.containsKey(r.getLid())) {
				levelToTopics.put(r.getLid(), Lists.newArrayList());
			}
			levelToTopics.get(r.getLid()).add(r.getCid());
		}
		cacheLevel2Topics.clear();
		cacheLevel2Topics.putAll(levelToTopics);
	}
	
	public List<String> getLevelIds() {
		return Lists.newArrayList(cacheLevel2Topics.keySet());
	}

	public List<String> getTopicsForLevel(String lid) {
		if (!cacheLevel2Topics.containsKey(lid))
			return null;
		return Lists.newArrayList(cacheLevel2Topics.get(lid));
	}
	
	public List<String> getTopicsForLevel(Collection<String> lids) {
		Set<String> cids = Sets.newHashSet();
		lids.forEach(lid -> cids.addAll(cacheLevel2Topics.get(lid)));
		return Lists.newArrayList(cids);
	}
}
