package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.enums.BrandEnum;
import com.jz.jar.media.request.VideoRequest;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.service.UserCollectVideoService;
import com.jz.jar.media.tool.VideoTool;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;

@Lazy
@Service
public class VideoProxy {

	@Autowired
	private MediaVideoService mediaVideoService;
	@Autowired
	private UserCollectVideoService userCollectVideoService;

	/** 获取视频信息 */
	public VideoWrapper getVideoInfo(VideoRequest request, BrandEnum brand) {
		MediaVideo video = mediaVideoService.getVideo(request.getWid(), brand);
		if (null == video)
			return null;
		VideoWrapper videoWrapper = this.getVideoWrapper(request.getUid(), request.getPid(), video);
		if (brand == BrandEnum.playabc) {
			return videoWrapper;
		}
		boolean isCollect = userCollectVideoService.isCollect(request.getUid(), request.getPid(), video.getWid());
		return videoWrapper.setIsCollect(isCollect);
	}

	public List<ItemCard> getVideoCards(VideoRequest request) {
		List<VideoWrapper> videos = this.getVideoInfos(request);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		return videos.stream().map(ItemCard::of).collect(Collectors.toList());
	}
	
	/** 此方法没有写入pid，需要外层自己补全 */
	public List<VideoWrapper> getVideoInfoNotPid(VideoRequest request) {
		// 获取视频信息
		List<MediaVideo> videos = mediaVideoService.findVideos(request.getWids());
		if (ArrayMapTools.isEmpty(videos))
			return null;
		List<VideoWrapper> wrappers = Lists.newArrayList();
		for (MediaVideo it : videos) {
			wrappers.add(this.getVideoWrapper(request.getUid(), null, it));
		}
		return wrappers;
	}
	
	public List<VideoWrapper> getVideoInfos(VideoRequest request) {
		List<VideoWrapper> videos = this.getVideoInfoNotPid(request);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		videos.forEach(it -> it.setPid(request.getPid()));
		return videos;
	}
	
	public List<VideoWrapper> getVideoInfoForWid2Pid(String uid, Map<String, String> wid2Pid) {
		List<VideoWrapper> videos = this.getVideoInfoNotPid(VideoRequest.of(uid, wid2Pid.keySet()));
		if (ArrayMapTools.isEmpty(videos))
			return null;
		videos.forEach(it -> it.setPid(wid2Pid.get(it.getWid())));
		return videos;
	}
	
	/** 获取视频信息 */
	private VideoWrapper getVideoWrapper(String uid, String pid, MediaVideo video) {
		VideoWrapper result = VideoWrapper.of(video).setPid(pid);
		// 获取可播放的地址
		VideoTool.getVideoUrl(video, result);
		// 获取封面地址
		VideoTool.getSnapshotUrl(uid, video, result);
		return result;
	}
}
