package com.jz.jar.media.wrapper;

import com.jz.jooq.franchise.tables.pojos.StudentInfo;

public class StudentWrapper {
	private StudentWrapper() {
	}

	private String suid;
	private String name;
	private String enName;
	private String sex;
	private String age;
	private String level;
	private Integer signCnt;
	private Integer playTitle;
	private String birthday;
	// 是否存在学校
	private Boolean isContainSchool;
	// 是否存在合同
	private Boolean isHaveContract;
	// 二维码字段
	private String qrCode;
	// 总课时
	private Integer totalLession;
	// 剩余课时
	private Integer remainingLession;

	public static StudentWrapper of(StudentInfo studentInfo) {
		return new StudentWrapper().setSuid(studentInfo.getSuid()).setName(studentInfo.getName())
				.setEnName(studentInfo.getEngName()).setSex(studentInfo.getSex())
				.setBirthday(studentInfo.getBirthday());
	}

	public String getSuid() {
		return suid;
	}

	public StudentWrapper setSuid(String suid) {
		this.suid = suid;
		return this;
	}

	public String getName() {
		return name;
	}

	public StudentWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getEnName() {
		return enName;
	}

	public StudentWrapper setEnName(String enName) {
		this.enName = enName;
		return this;
	}

	public String getSex() {
		return sex;
	}

	public StudentWrapper setSex(String sex) {
		this.sex = sex;
		return this;
	}

	public String getAge() {
		return age;
	}

	public StudentWrapper setAge(String age) {
		this.age = age;
		return this;
	}

	public String getLevel() {
		return level;
	}

	public StudentWrapper setLevel(String level) {
		this.level = level;
		return this;
	}

	public Integer getSignCnt() {
		return signCnt;
	}

	public StudentWrapper setSignCnt(Integer signCnt) {
		this.signCnt = signCnt;
		return this;
	}

	public Integer getPlayTitle() {
		return playTitle;
	}

	public StudentWrapper setPlayTitle(Integer playTitle) {
		this.playTitle = playTitle;
		return this;
	}

	public String getBirthday() {
		return birthday;
	}

	public StudentWrapper setBirthday(String birthday) {
		this.birthday = birthday;
		return this;
	}

	public Boolean getIsContainSchool() {
		return isContainSchool;
	}

	public StudentWrapper setIsContainSchool(Boolean isContainSchool) {
		this.isContainSchool = isContainSchool;
		return this;
	}

	public Boolean getIsHaveContract() {
		return isHaveContract;
	}

	public StudentWrapper setIsHaveContract(Boolean isHaveContract) {
		this.isHaveContract = isHaveContract;
		return this;
	}

	public String getQrCode() {
		return qrCode;
	}

	public StudentWrapper setQrCode(String qrCode) {
		this.qrCode = qrCode;
		return this;
	}

	public Integer getTotalLession() {
		return totalLession;
	}

	public StudentWrapper setTotalLession(Integer totalLession) {
		this.totalLession = totalLession;
		return this;
	}

	public Integer getRemainingLession() {
		return remainingLession;
	}

	public StudentWrapper setRemainingLession(Integer remainingLession) {
		this.remainingLession = remainingLession;
		return this;
	}

}
