/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.tool;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.jar.media.tool.PictureCompress;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunBean {
    private static AliyunBean _this;
    @Value(value="${aliyun.access.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.key.secret}")
    private String accessSecret;
    @Value(value="${aliyun.oss.media.bucket}")
    private String ossMediaBucket;
    @Value(value="${aliyun.oss.images.domain}")
    private String ossImagesDomain;
    @Value(value="${aliyun.oss.media.domain}")
    private String ossMediaDomain;

    @PostConstruct
    public void registerClassInstance() {
        _this = this;
    }

    public static AliyunConfig getMediaAliyunConfig() {
        return AliyunConfig.of((String)AliyunBean._this.ossMediaDomain, (String)AliyunBean._this.accessKeyId, (String)AliyunBean._this.accessSecret, (String)AliyunBean._this.ossMediaBucket);
    }

    public static String getImagesUrl(String url, PictureCompress compress) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        String resultUrl = AliyunBean.getImagesUrl(url);
        if (null == compress) {
            return resultUrl;
        }
        return resultUrl + "!" + compress.getCompressName();
    }

    public static String getImagesUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        return AliyunBean._this.ossImagesDomain + "/" + url;
    }

    public static List<String> mutiGenImageUrl(String str) {
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            ArrayList list = Lists.newArrayList();
            for (String s : StringUtils.split((String)str, (String)",")) {
                list.add(AliyunBean.getImagesUrl(s));
            }
            return list;
        }
        return null;
    }
}

