package com.jz.jar.media.tool;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.google.common.collect.Lists;

public class OssTrimUtil {

	public static String trimAddress(String path) {
		if (null == path)
			return null;
		if (path.startsWith("https://"))
			path = path.replace("https://", "http://");
		if (path.startsWith("http://")) {
			path = path.substring(7);
			path = path.substring(path.indexOf("/") + 1, path.length());
		}
		if (path.indexOf("!") > 0) { // 本地存在压缩策略，需要去除
			path = path.substring(0, path.indexOf("!"));
		}
		return path.startsWith("/") ? path.substring(1) : path;
	}

	public static String mutiTrimAddresses(String str) {
		if (StringUtils.isEmpty(str)) {
			return str;
		}
		List<String> items = Lists.newArrayList();
		for (String p : StringUtils.split(str, ",")) {
			items.add(trimAddress(p));
		}
		return StringUtils.join(items, ",");
	}
}
