package com.jz.jar.media.wrapper;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jz.jar.media.common.LessonStatus;
import com.jz.jooq.franchise.tables.pojos.Lesson;

/**
 * @Title LessonWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年8月21日 下午5:29:01
 * @version V1.0
 */
public class LessonWrapper {
	private LessonWrapper() {
	}

	private String schoolId;
	private String lessonId;
	// 课程名称
	private String lessonName;
	// 第几节
	private Integer lessonTimes;
	private String lessonTitle;
	private Long startTime;
	private Long endTime;
	// 上课的状态
	private LessonStatus classStatus;
	// 教室
	private String classroom;
	// 学员的上课状态
	private List<LessonStatus> studentClassStatus;
	// 教师
	private TeacherWrapper teacher;
	// 是否已请假
	private Boolean isLeave;
	// 合同id
	private String contractId;
	// 当前合同的请假次数
	private Integer currentLeaveNum;
	// 当前合同的请假次数
	private Integer schoolLeaveNum;
	// 剩余的请假次数
	private Integer restLeaveNum;
	// 专辑
	private PlaylistWrapper playlist;

	public static LessonWrapper of(Lesson lesson) {
		return new LessonWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId())
				.setLessonTimes(lesson.getLessonTime()).setLessonTitle(lesson.getContent())
				.setStartTime(lesson.getStartTime()).setEndTime(lesson.getEndTime());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public LessonWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getLessonId() {
		return lessonId;
	}

	public LessonWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public String getLessonName() {
		return lessonName;
	}

	public LessonWrapper setLessonName(String lessonName) {
		this.lessonName = lessonName;
		return this;
	}

	public Integer getLessonTimes() {
		return lessonTimes;
	}

	public LessonWrapper setLessonTimes(Integer lessonTimes) {
		this.lessonTimes = lessonTimes;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public LessonWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public LessonWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public LessonWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public LessonStatus getClassStatus() {
		return classStatus;
	}

	public LessonWrapper setClassStatus(LessonStatus classStatus) {
		this.classStatus = classStatus;
		return this;
	}

	public String getClassroom() {
		return classroom;
	}

	public LessonWrapper setClassroom(String classroom) {
		this.classroom = classroom;
		return this;
	}

	public List<LessonStatus> getStudentClassStatus() {
		return studentClassStatus;
	}

	public LessonWrapper setStudentClassStatus(List<LessonStatus> studentClassStatus) {
		this.studentClassStatus = studentClassStatus;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public LessonWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

	public Boolean getIsLeave() {
		return isLeave;
	}

	public LessonWrapper setIsLeave(Boolean isLeave) {
		this.isLeave = isLeave;
		return this;
	}

	public String getContractId() {
		return contractId;
	}

	public LessonWrapper setContractId(String contractId) {
		this.contractId = contractId;
		return this;
	}

	@JsonIgnore
	public Integer getCurrentLeaveNum() {
		return currentLeaveNum;
	}

	public LessonWrapper setCurrentLeaveNum(Integer currentLeaveNum) {
		this.currentLeaveNum = currentLeaveNum;
		return this;
	}

	public Integer getSchoolLeaveNum() {
		return schoolLeaveNum;
	}

	public LessonWrapper setSchoolLeaveNum(Integer schoolLeaveNum) {
		this.schoolLeaveNum = schoolLeaveNum;
		return this;
	}

	public Integer getRestLeaveNum() {
		if (null != restLeaveNum)
			return restLeaveNum;
		if (null != schoolLeaveNum && null != currentLeaveNum) {
			restLeaveNum = schoolLeaveNum - currentLeaveNum;
			return restLeaveNum = restLeaveNum < 0 ? 0 : restLeaveNum;
		}
		if (null != schoolLeaveNum)
			return schoolLeaveNum;
		return restLeaveNum;
	}

	public LessonWrapper setRestLeaveNum(Integer restLeaveNum) {
		return this;
	}

	public PlaylistWrapper getPlaylist() {
		return playlist;
	}

	public LessonWrapper setPlaylist(PlaylistWrapper playlist) {
		this.playlist = playlist;
		return this;
	}

}
