package com.jz.jar.media.wrapper;

import java.util.List;

import com.google.common.collect.Lists;
import com.jz.jooq.media.tables.pojos.Topic;

public class TopicWrapper {
	private TopicWrapper() {
	}

	private String cid;
	private String name;
	private String leftIcon;
	private String downIcon;
	private String classifyIcon;
	private Integer playlistCount;
	private List<PlaylistWrapper> playlist;

	public static TopicWrapper of(Topic topic) {
		return new TopicWrapper().setCid(topic.getCid()).setName(topic.getName()).setLeftIcon(topic.getLeftIcon())
				.setDownIcon(topic.getDownIcon()).setClassifyIcon(topic.getClassifyIcon());
	}

	public String getCid() {
		return cid;
	}

	public TopicWrapper setCid(String cid) {
		this.cid = cid;
		return this;
	}

	public String getName() {
		return name;
	}

	public TopicWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getLeftIcon() {
		return leftIcon;
	}

	public TopicWrapper setLeftIcon(String leftIcon) {
		this.leftIcon = leftIcon;
		return this;
	}

	public String getDownIcon() {
		return downIcon;
	}

	public TopicWrapper setDownIcon(String downIcon) {
		this.downIcon = downIcon;
		return this;
	}

	public String getClassifyIcon() {
		return classifyIcon;
	}

	public TopicWrapper setClassifyIcon(String classifyIcon) {
		this.classifyIcon = classifyIcon;
		return this;
	}

	public Integer getPlaylistCount() {
		return playlistCount;
	}

	public TopicWrapper setPlaylistCount(Integer playlistCount) {
		this.playlistCount = playlistCount;
		return this;
	}

	public List<PlaylistWrapper> getPlaylist() {
		return playlist;
	}

	public TopicWrapper setPlaylist(List<PlaylistWrapper> playlist) {
		this.playlist = playlist;
		return this;
	}

	public TopicWrapper addPlaylist(PlaylistWrapper plwer) {
		if (null == plwer)
			return this;
		if (null == this.playlist) {
			this.playlist = Lists.newArrayList();
		}
		this.playlist.add(plwer);
		return this;
	}
}
