/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.tool;

import com.jz.aliyun.beans.AliyunConfig;
import com.jz.jar.media.tool.PictureCompress;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AliyunBean {
    private static AliyunBean _this;
    @Value(value="${aliyun.access.key.id}")
    private String accessKeyId;
    @Value(value="${aliyun.access.key.secret}")
    private String accessSecret;
    @Value(value="${aliyun.oss.endpoint}")
    private String ossEndpoint;
    @Value(value="${aliyun.oss.media.bucket}")
    private String ossMediaBucket;
    @Value(value="${aliyun.oss.screenshot.bucket}")
    private String ossScreenshotBucket;
    @Value(value="${aliyun.oss.images.bucket}")
    private String ossImagesBucket;
    @Value(value="${aliyun.oss.images.domain}")
    private String ossImagesDomain;

    @PostConstruct
    public void registerClassInstance() {
        _this = this;
    }

    public static AliyunConfig getMediaAliyunConfig() {
        return AliyunConfig.of((String)AliyunBean._this.ossEndpoint, (String)AliyunBean._this.accessKeyId, (String)AliyunBean._this.accessSecret, (String)AliyunBean._this.ossMediaBucket);
    }

    public static String getImagesUrl(String url, PictureCompress compress) {
        if (null == url) {
            return null;
        }
        String resultUrl = AliyunBean.getImagesUrl(url);
        if (null == compress) {
            return resultUrl;
        }
        return resultUrl + "!" + compress.getCompressName();
    }

    public static String getImagesUrl(String url, Long timestamp, PictureCompress compress) {
        String showUrl = AliyunBean.getImagesUrl(url, compress);
        if (null == showUrl) {
            return null;
        }
        if (null == timestamp) {
            return showUrl;
        }
        return showUrl + "?" + timestamp;
    }

    public static String getImagesUrl(String url) {
        if (null == url) {
            return null;
        }
        return AliyunBean._this.ossImagesDomain + "/" + url;
    }
}

