/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.enums.UploadVideoStatus;
import com.jz.jar.media.service.UploadVideoService;
import com.jz.jar.media.tool.VideoTool;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.UploadVideo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UploadVideoProxy {
    private static final List<UploadVideoStatus> validStatus = Arrays.asList(UploadVideoStatus.online, UploadVideoStatus.wating, UploadVideoStatus.verifying, UploadVideoStatus.notPassed);
    @Autowired
    private UploadVideoService uploadVideoService;

    public boolean isStudentUploadVideo(String wid) {
        return wid.startsWith("sv_");
    }

    public int countVideoForUid(String uid, String app) {
        return this.uploadVideoService.countVideos(uid, validStatus, app);
    }

    public List<ItemCard> getVideosForUid(String uid, String app, int start, int size) {
        return this.packageVideoCard(uid, this.uploadVideoService.getVideos(uid, validStatus, app, start, size));
    }

    public VideoWrapper packageVideoWrapper(UploadVideo video) {
        if (null == video) {
            return null;
        }
        VideoWrapper vw = VideoWrapper.of(video);
        if (UploadVideoStatus.online.getCode() == video.getStatus().intValue()) {
            VideoTool.getVideoUrl(video, vw);
            VideoTool.getSnapshotUrl(video.getUid(), video, vw);
            return vw;
        }
        VideoTool.getUploadVideoDefault(vw);
        return vw;
    }

    public VideoWrapper packageVideoWrapper(String uid, UploadVideo video) {
        VideoWrapper vw = VideoWrapper.of(video);
        if (UploadVideoStatus.online.getCode() == video.getStatus().intValue()) {
            VideoTool.getVideoUrl(video, vw);
            VideoTool.getSnapshotUrl(uid, video, vw);
            return vw;
        }
        VideoTool.getUploadVideoDefault(vw);
        return vw;
    }

    public List<ItemCard> packageVideoCard(String uid, Collection<String> wids) {
        if (ArrayMapTools.isEmpty(wids)) {
            return null;
        }
        return this.packageVideoCard(uid, this.uploadVideoService.getVideoInfo(wids));
    }

    public List<ItemCard> packageVideoCard(String uid, List<UploadVideo> videos) {
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(it -> ItemCard.of(this.packageVideoWrapper(uid, (UploadVideo)it))).collect(Collectors.toList());
    }
}

