/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.tool.VideoTool;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VideoProxy {
    @Autowired
    private MediaVideoService mediaVideoService;

    public ItemCard getVideoCard(String uid, String pid, String wid) {
        VideoWrapper wrapper = this.getVideoInfo(uid, pid, wid);
        if (null == wrapper) {
            return null;
        }
        return ItemCard.of(wrapper);
    }

    public VideoWrapper getVideoInfo(String uid, String pid, String wid) {
        MediaVideo video = this.mediaVideoService.getVideo(wid);
        if (null == video) {
            return null;
        }
        return this.getVideoWrapper(uid, pid, video);
    }

    public List<ItemCard> getVideoCards(String uid, String pid, Collection<String> wids) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, pid, wids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoInfo(String uid, Collection<String> wids) {
        List videos = this.mediaVideoService.findVideos(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (MediaVideo it : videos) {
            wrappers.add(this.getVideoWrapper(uid, null, it));
        }
        return wrappers;
    }

    public List<VideoWrapper> getVideoInfo(String uid, String pid, Collection<String> wids) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, wids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        videos.forEach(it -> it.setPid(pid));
        return videos;
    }

    public List<VideoWrapper> getVideoInfoForWid2Pid(String uid, Map<String, String> wid2Pid) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, wid2Pid.keySet());
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        videos.forEach(it -> it.setPid((String)wid2Pid.get(it.getWid())));
        return videos;
    }

    private VideoWrapper getVideoWrapper(String uid, String pid, MediaVideo video) {
        VideoWrapper result = VideoWrapper.of(video).setPid(pid);
        VideoTool.getVideoUrl(video, result);
        VideoTool.getSnapshotUrl(uid, video, result);
        return result;
    }
}

