package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.service.QuestionOptionService;
import com.jz.jar.media.service.QuestionService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.QuestionOptionWrapper;
import com.jz.jar.media.wrapper.QuestionWrapper;
import com.jz.jooq.media.tables.pojos.Question;
import com.jz.jooq.media.tables.pojos.QuestionOption;

/**
 * @Title QuestionProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年9月4日 下午5:14:57
 * @version V1.0
 */
@Lazy
@Service
public class QuestionProxy {

	@Autowired
	private QuestionService questionService;
	@Autowired
	private QuestionOptionService questionOptionService;

	public List<QuestionWrapper> getQuestion(Collection<String> qids) {
		List<Question> questions = questionService.getQuestions(qids);
		if (ArrayMapTools.isEmpty(questions))
			return null;
		// 打乱问题顺序
		Collections.shuffle(questions);
		Map<String, List<QuestionOptionWrapper>> qid2Options = this.getQuestionOptions(qids);
		List<QuestionWrapper> wrappers = Lists.newArrayList();
		questions.forEach(it -> {
			// 无选项则是无效的问题
			if (!qid2Options.containsKey(it.getQid())) {
				return;
			}
			QuestionWrapper qw = QuestionWrapper.of(it);
			wrappers.add(qw);
			// 设置音频和图片的地址
			qw.setAudio(AliyunBean.getScreenshotUrl(it.getAudio())).setPic(AliyunBean.getScreenshotUrl(it.getPic()));
			// 设置选项
			qw.setOptions(qid2Options.get(it.getQid()));
			// 打乱选项的顺序
			Collections.shuffle(qw.getOptions());
		});
		return wrappers;
	}

	public Map<String, List<QuestionOptionWrapper>> getQuestionOptions(Collection<String> qids) {
		List<QuestionOption> options = questionOptionService.getQuestionOptions(qids);
		if (ArrayMapTools.isEmpty(options))
			return Maps.newHashMap();
		Map<String, List<QuestionOptionWrapper>> qid2Options = Maps.newHashMap();
		options.forEach(it -> {
			QuestionOptionWrapper op = QuestionOptionWrapper.of(it);
			// 设置图片地址
			op.setPic(AliyunBean.getScreenshotUrl(it.getPic()));
			if (!qid2Options.containsKey(it.getQid()))
				qid2Options.put(it.getQid(), Lists.newArrayList());
			qid2Options.get(it.getQid()).add(op);
		});
		return qid2Options;
	}
}
