package com.jz.jar.media.tool;

import java.util.List;
import java.util.Map;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import com.jz.jooq.media.tables.pojos.UploadVideo;

/**
 * @Title VideoTool
 * @Package com.jz.jar.media.tool
 * @author tangjunfeng
 * @date 2018年9月11日 下午4:14:38
 * @version V1.0
 */
public class VideoTool {

	private static String getSnapshotName(int cnt) {
		return (cnt < 10 ? "0000" : "000") + cnt;
	}

	private static void getSnapshotUrl(VideoWrapper wrapper, String snapshotUrl, Integer cnt) {
		if (StringTools.isEmptyAndBlank(snapshotUrl))
			return;
		// 图片地址
		cnt = null == cnt ? 1 : cnt;
		String tempUrl = snapshotUrl.replace("{Count}", getSnapshotName(cnt));
		wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
	}

	public static void getSnapshotUrl(String uid, UploadVideo video, VideoWrapper wrapper) {
		int cnt = 1;
		if (StringTools.isNotEmptyAndBlank(uid) && null != video.getSnapshotCnt())
			cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
		getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt);
	}

	public static void getSnapshotUrl(String uid, MediaVideo video, VideoWrapper wrapper) {
		// 图片地址
		int cnt = -1;
		if (null != video.getSelectedSnapshot()) {
			cnt = video.getSelectedSnapshot(); // 已经选择了视频封面
		} else if (StringTools.isNotEmptyAndBlank(uid)) { // 未选择视频封面，就随机给一张
			cnt = Math.abs(uid.hashCode()) % video.getSnapshotCnt();
		} else { // 使用第一张图
			cnt = 1;
		}
		getSnapshotUrl(wrapper, video.getSnapshotUrl(), cnt);
	}

	/** 获取视频的相关文件路径 */
	public static void getVideoUrl(MediaVideo video, VideoWrapper wrapper) {
		getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
	}

	/** 获取视频的相关文件路径 */
	public static void getVideoUrl(UploadVideo video, VideoWrapper wrapper) {
		getVideoUrl(wrapper, video.getHd(), video.getNormal(), video.getLow(), video.getAudit());
	}

	/** 获取视频的相关文件路径 */
	private static void getVideoUrl(VideoWrapper wrapper, String hd, String normal, String low, String audit) {
		AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
		List<String> urls = Lists.newArrayList();
		addToList(urls, hd, normal, low, audit);
		if (urls.isEmpty())
			return;
		// 一个小时
		Map<String, String> key2Url = OssTools.getInstance(aliyunConfig).getUrl(urls, 3600);
		// 视频地址
		wrapper.setHd(key2Url.get(hd));
		wrapper.setNormal(key2Url.get(normal));
		wrapper.setLow(key2Url.get(low));
		// 音频地址
		wrapper.setAudit(key2Url.get(audit));
	}

	private static void addToList(List<String> urls, String... args) {
		for (String arg : args) {
			if (null != arg)
				urls.add(arg);
		}
	}
}
