/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.service.MediaVideoService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.MediaVideo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class VideoProxy {
    @Autowired
    private MediaVideoService mediaVideoService;

    private String getSnapshotName(int cnt) {
        return (cnt < 10 ? "0000" : "000") + cnt;
    }

    private void getSnapshotUrl(String uid, MediaVideo video, VideoWrapper wrapper) {
        int cnt = -1;
        cnt = null != video.getSelectedSnapshot() ? video.getSelectedSnapshot() : (StringTools.isNotEmptyAndBlank((String)uid) ? Math.abs(uid.hashCode()) % video.getSnapshotCnt() : 1);
        String tempUrl = video.getSnapshotUrl().replace("{Count}", this.getSnapshotName(cnt));
        wrapper.setSnapshotUrl(AliyunBean.getScreenshotUrl(tempUrl));
    }

    private void getVideoUrl(MediaVideo video, VideoWrapper wrapper) {
        AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
        ArrayList urls = Lists.newArrayList((Object[])new String[]{video.getHd(), video.getNormal(), video.getNormal(), video.getAudit()});
        Map key2Url = OssTools.getInstance((AliyunConfig)aliyunConfig).getUrl((Collection)urls, 3600);
        wrapper.setHd((String)key2Url.get(video.getHd()));
        wrapper.setNormal((String)key2Url.get(video.getNormal()));
        wrapper.setLow((String)key2Url.get(video.getLow()));
        wrapper.setAudit((String)key2Url.get(video.getAudit()));
    }

    public ItemCard getVideoCard(String uid, String pid, String wid) {
        VideoWrapper wrapper = this.getVideoInfo(uid, pid, wid);
        if (null == wrapper) {
            return null;
        }
        return ItemCard.of(wrapper);
    }

    public VideoWrapper getVideoInfo(String uid, String pid, String wid) {
        MediaVideo video = this.mediaVideoService.getVideo(wid);
        if (null == video) {
            return null;
        }
        return this.getVideoWrapper(uid, pid, video);
    }

    public List<ItemCard> getVideoCards(String uid, String pid, Collection<String> wids) {
        List<VideoWrapper> videos = this.getVideoInfo(uid, pid, wids);
        if (ArrayMapTools.isEmpty(videos)) {
            return null;
        }
        return videos.stream().map(ItemCard::of).collect(Collectors.toList());
    }

    public List<VideoWrapper> getVideoInfo(String uid, String pid, Collection<String> wids) {
        List videos = this.mediaVideoService.findVideos(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (MediaVideo it : videos) {
            wrappers.add(this.getVideoWrapper(uid, pid, it));
        }
        return wrappers;
    }

    public List<VideoWrapper> getVideoInfo(String uid, Collection<String> wids) {
        List videos = this.mediaVideoService.findVideos(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        ArrayList wrappers = Lists.newArrayList();
        for (MediaVideo it : videos) {
            wrappers.add(this.getVideoWrapper(uid, null, it));
        }
        return wrappers;
    }

    private VideoWrapper getVideoWrapper(String uid, String pid, MediaVideo video) {
        VideoWrapper result = VideoWrapper.of(video).setPid(pid);
        this.getVideoUrl(video, result);
        this.getSnapshotUrl(uid, video, result);
        return result;
    }
}

