package com.jz.jar.media.wrapper;

import java.util.List;

import com.jz.jooq.media.tables.pojos.Quiz;

/**
 * @Title QuizWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年9月4日 下午5:25:28
 * @version V1.0
 */
public class QuizWrapper {
	private QuizWrapper() {
	}

	private String qzid;
	private String name;
	private Integer timeSeconds;
	private Integer totalScore;
	private List<QuestionWrapper> questions;

	public static QuizWrapper of(Quiz quiz) {
		return new QuizWrapper().setQzid(quiz.getQzid()).setName(quiz.getName()).setTotalScore(quiz.getTotalScore())
				.setTimeSeconds(quiz.getTime() * 60);
	}

	public String getQzid() {
		return qzid;
	}

	public QuizWrapper setQzid(String qzid) {
		this.qzid = qzid;
		return this;
	}

	public String getName() {
		return name;
	}

	public QuizWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public Integer getTimeSeconds() {
		return timeSeconds;
	}

	public QuizWrapper setTimeSeconds(Integer timeSeconds) {
		this.timeSeconds = timeSeconds;
		return this;
	}

	public Integer getTotalScore() {
		return totalScore;
	}

	public QuizWrapper setTotalScore(Integer totalScore) {
		this.totalScore = totalScore;
		return this;
	}

	public List<QuestionWrapper> getQuestions() {
		return questions;
	}

	public QuizWrapper setQuestions(List<QuestionWrapper> questions) {
		this.questions = questions;
		return this;
	}

}
