package com.jz.jar.media.wrapper;

import java.util.List;

import com.jz.jooq.media.tables.pojos.Question;

public class QuestionWrapper {
	private QuestionWrapper() {
	}

	private String qid;
	private String name;
	private String audio;
	private String pic;
	private List<QuestionOptionWrapper> options;

	public static QuestionWrapper of() {
		return new QuestionWrapper();
	}

	public static QuestionWrapper of(Question question) {
		return of().setQid(question.getQid()).setName(question.getName()).setAudio(question.getAudio())
				.setPic(question.getPic());
	}

	public String getQid() {
		return qid;
	}

	public QuestionWrapper setQid(String qid) {
		this.qid = qid;
		return this;
	}

	public String getName() {
		return name;
	}

	public QuestionWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getAudio() {
		return audio;
	}

	public QuestionWrapper setAudio(String audio) {
		this.audio = audio;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public QuestionWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public List<QuestionOptionWrapper> getOptions() {
		return options;
	}

	public QuestionWrapper setOptions(List<QuestionOptionWrapper> options) {
		this.options = options;
		return this;
	}

}
