package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.tuple.Triple;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.jar.media.service.UserSignService;
import com.jz.jar.media.wrapper.TitleWrapper;

/**
 * @Title PlayTitleProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月2日 下午5:17:21
 * @version V1.0
 */
@Lazy
@Service
public class PlayTitleProxy {

	private static final List<Triple<Integer, Integer, String>> titleConfig = Lists.newArrayList();

	@Autowired
	private UserSignService userSignService;

	static {
		titleConfig.add(Triple.of(0, 29, "小小体验官"));
		titleConfig.add(Triple.of(30, 49, "英语小标兵"));
		titleConfig.add(Triple.of(50, 99, "天才小博士"));
		titleConfig.add(Triple.of(100, 129, "英语小专家"));
		titleConfig.add(Triple.of(130, Integer.MAX_VALUE, "天才发明家"));
	}
	
	public Map<String, Integer> getCountDays(String uid, Collection<String> suidArray) {
		return userSignService.getCountDays(uid, suidArray);
	}
	
	public int getSignCnt(String uid, String suid) {
		return userSignService.countDays(uid, suid);
	}
	
	/** 获取用户称号 */
	public String getTitle(int signDays) {
		for (Triple<Integer, Integer, String> triple : titleConfig) {
			if (triple.getLeft() <= signDays && signDays <= triple.getMiddle()) {
				return triple.getRight();
			}
		}
		return titleConfig.get(0).getRight();
	}
	
	/** 获取下一个称号还需要多少天 */
	public TitleWrapper getNextTitleDays(int signDays) {
		Triple<Integer, Integer, String> triple = null;
		int tempIndex = -1;
		for (int i = 0; i < titleConfig.size(); i++) {
			triple = titleConfig.get(i);
			if (triple.getLeft() <= signDays && signDays <= triple.getMiddle()) {
				tempIndex = i + 1; // 下一个称号
				break;
			}
		}
		// 未匹配到 || 最后一个
		if (tempIndex == -1 || tempIndex >= titleConfig.size())
			return null;
		triple = titleConfig.get(tempIndex);
		return TitleWrapper.of(triple.getLeft() - signDays, triple.getRight());
	}
	
	public List<TitleWrapper> getTitles() {
		List<TitleWrapper> result = Lists.newArrayList();
		Triple<Integer, Integer, String> triple = null;
		for (int i = 1; i < titleConfig.size(); i++) {
			triple = titleConfig.get(i);
			result.add(TitleWrapper.of(triple.getLeft(), titleConfig.get(i - 1).getRight()));
		}
		// 获取最后一个
		triple = titleConfig.get(titleConfig.size() - 1);
		result.add(TitleWrapper.of(triple.getLeft(), triple.getRight()));
		return result;
	}
	
}
