/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.cache.SpecialPracticeCache;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jar.media.service.SpecialPracticeHistoryService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class SpecialPracticeProxy {
    private static final BigDecimal _100 = new BigDecimal(100);
    @Autowired
    private PlaylistRelationService playlistRelationService;
    @Autowired
    private SpecialPracticeHistoryService specialPracticeHistoryService;
    @Autowired
    private SpecialPracticeCache specialPracticeCache;

    public int countSpecialPlaylist(String suid, String cid, boolean isFinished) {
        return this.specialPracticeCache.countSpecialPlaylist(suid, cid, isFinished);
    }

    public Map<String, Integer> getSpecialPlaylist(String suid, String lid, String cid, boolean isFinished, int start, int size) {
        int toIndex;
        Map playlist = this.specialPracticeCache.getSpecialPlaylist(suid, cid, isFinished, start, size);
        if (null != playlist) {
            return playlist;
        }
        Pair<Map<String, Integer>, Map<String, Integer>> pair = this.cutSpecialPracticePlaylist(suid, lid, cid);
        Map map = playlist = isFinished ? (Map)pair.getRight() : (Map)pair.getLeft();
        if (null == playlist) {
            return null;
        }
        int fromIndex = start < 0 ? 0 : start;
        int n = toIndex = playlist.size() >= start + size ? start + size : playlist.size();
        if (fromIndex < toIndex) {
            Map resultPlaylist = playlist;
            ArrayList keys = Lists.newArrayList(playlist.keySet());
            return keys.subList(fromIndex, toIndex).stream().collect(Collectors.toMap(it -> it, it -> (Integer)resultPlaylist.get(it)));
        }
        return null;
    }

    public Pair<Map<String, Integer>, Map<String, Integer>> cutSpecialPracticePlaylist(String suid, String lid, String cid) {
        List pidArray = this.playlistRelationService.findSpecialPlaylist(lid, cid);
        List histories = this.specialPracticeHistoryService.getHistoryForPlaylist(suid, (Collection)pidArray);
        LinkedHashMap unfinished = Maps.newLinkedHashMap();
        LinkedHashMap finished = Maps.newLinkedHashMap();
        if (ArrayMapTools.isEmpty((Collection)histories)) {
            unfinished.putAll(pidArray.stream().collect(Collectors.toMap(it -> it, it -> 0)));
        } else {
            histories.forEach(hy -> {
                if (hy.getPlayCnt() >= hy.getTargetCnt()) {
                    finished.put(hy.getPid(), 100);
                    return;
                }
                BigDecimal targetCnt = new BigDecimal(hy.getTargetCnt());
                int percent = new BigDecimal(hy.getPlayCnt()).divide(targetCnt, 2, 4).multiply(_100).intValue();
                unfinished.put(hy.getPid(), percent);
            });
        }
        this.specialPracticeCache.setSpecialPlaylist(suid, cid, unfinished, false);
        this.specialPracticeCache.setSpecialPlaylist(suid, cid, finished, true);
        return Pair.of((Object)unfinished, (Object)finished);
    }
}

