package com.jz.jar.media.proxy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.common.utils.datetime.TimeTools;
import com.jz.jar.media.service.QuizClassifyService;
import com.jz.jar.media.service.QuizService;
import com.jz.jar.media.service.QuizStudentScoreService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jooq.media.tables.pojos.Quiz;
import com.jz.jooq.media.tables.pojos.QuizStudentScore;

/**
 * @Title QuizProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月16日 下午5:12:17
 * @version V1.0
 */
@Lazy
@Service
public class QuizProxy {

	@Autowired
	private QuizClassifyService quizClassifyService;
	@Autowired
	private QuizService quizService;
	@Autowired
	private QuizStudentScoreService quizStudentScoreService;
	
	/** 获取当前上周（201837） */
	public int getLastWeek() {
		return TimeTools.getLastWeekOfYear();
	}
	
	/** 获取当前周（201838） */
	public int getCurrentWeek() {
		return TimeTools.getCurrentWeekOfYear();
	}

	/** 获取本周的试卷 */
	public Quiz getCurrentWeekQuizForLevel(String lid) {
		String quizId = quizClassifyService.getQuizForLidAndWeek(lid, getCurrentWeek());
		if (null == quizId)
			return null;
		Quiz quiz = quizService.getQuiz(quizId);
		if (null == quiz)
			return null;
		AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
		quiz.setZip(OssTools.getInstance(aliyunConfig).getUrl(quiz.getZip(), 3600));
		return quiz;
	}
	
	/** 保存学员本周的考试成绩 */
	public void saveCurrentWeekStudentQuizScore(String suid, String qzid, int score, int totalScore) {
		quizStudentScoreService.saveStudentScore(suid, getCurrentWeek(), qzid, score, totalScore);
	}
	
	/** 获取本周的考试成绩 */
	public QuizStudentScore getCurrentWeekStudentScore(String suid) {
		return quizStudentScoreService.getStudentScore(suid, getCurrentWeek());
	}
}
