package com.jz.jar.media.proxy;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.service.StudentSchoolContractService;
import com.jz.jar.media.tool.Global;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;

/**
 * @Title StudentInfoProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月8日 下午3:11:23
 * @version V1.0
 */
@Lazy
@Service
public class StudentInfoProxy {

	@Autowired
	private StudentInfoService studentInfoService;
	@Autowired
	private StudentSchoolContractService studentSchoolContractService;
	@Autowired
	private PlayTitleProxy playTitleProxy;
	@Autowired
	private StudentLevelProxy studentLevelProxy;

	/** 获取用户下的所有学员 */
	public List<StudentWrapper> getStudents(String puid) {
		List<StudentInfo> students = studentInfoService.getStudents(puid);
		if (ArrayMapTools.isEmpty(students))
			return null;
		List<String> suids = students.stream().map(it -> it.getSuid()).collect(Collectors.toList());
		Map<String, Integer> suid2Cnt = playTitleProxy.getCountDays(puid, suids);
		Map<String, Pair<Integer, Integer>> hasLession = studentSchoolContractService.getLessionCount(suids);
		List<StudentWrapper> wrappers = Lists.newArrayList();
		int signCnt = 0;
		for (StudentInfo st : students) {
			signCnt = ArrayMapTools.getIntValue(suid2Cnt, st.getSuid(), 0);
			wrappers.add(getWrapper(st, signCnt, hasLession.get(st.getSuid())));
		}
		return wrappers;
	}

	/** 获取用户下的所有学员 */
	public StudentWrapper getStudent(String puid, String suid) {
		StudentInfo st = studentInfoService.getStudent(suid);
		if (null == st)
			return null;
		Pair<Integer, Integer> lessionCount = studentSchoolContractService.getLessionCount(st.getSuid());
		return getWrapper(st, playTitleProxy.getSignCnt(puid, suid), lessionCount);
	}

	/** 获取学员的年龄 */
	private String getShowStudentAge(StudentInfo studentInfo) {
		Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(studentInfo.getBirthday());
		StringBuffer sb = new StringBuffer().append(getAgeContent(yearOfMonth.getLeft(), "岁"));
		sb.append(getAgeContent(yearOfMonth.getRight(), "个月"));
		return sb.toString();
	}

	private StudentWrapper getWrapper(StudentInfo st, int signCnt, Pair<Integer, Integer> lessionCount) {
		StudentWrapper student = StudentWrapper.of(st).setAge(getShowStudentAge(st))
				.setLevel(studentLevelProxy.getLidForBirthday(st.getBirthday())).setSignCnt(signCnt)
				.setPlayTitle(playTitleProxy.getTitle(signCnt)).setQrCode(getQRCode(st.getSuid()));
		if (null != lessionCount) {
			student.setTotalLession(lessionCount.getLeft()).setRemainingLession(lessionCount.getRight());
		} else {
			student.setTotalLession(0).setRemainingLession(0);
		}
		return student;
	}

	private static String getAgeContent(int num, String content) {
		return num <= 0 ? "" : num + content;
	}

	private static String getQRCode(String suid) {
		return "suid=" + suid;
	}
}
