/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.enums.UploadVideoStatus;
import com.jz.jar.media.service.UploadVideoService;
import com.jz.jar.media.wrapper.VideoWrapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class UploadVideoProxy {
    @Autowired
    private UploadVideoService uploadVideoService;

    private boolean isStudentUploadVideo(String wid) {
        return wid.startsWith("sv_");
    }

    public void saveToWaiting(String wid, String uid, String name) {
        if (this.isStudentUploadVideo(wid)) {
            this.uploadVideoService.saveToWaiting(wid, uid, name);
        }
    }

    private List<UploadVideoStatus> getStatus() {
        return Arrays.asList(UploadVideoStatus.online, UploadVideoStatus.wating, UploadVideoStatus.verifying, UploadVideoStatus.notPassed);
    }

    public int countMyVideos(String uid) {
        return this.uploadVideoService.countVideos(uid, this.getStatus());
    }

    public List<ItemCard> getMyVideos(String uid, int start, int size) {
        return this.packageVideoCard(this.uploadVideoService.getVideos(uid, this.getStatus(), start, size));
    }

    public int countOnlineVideosNotMe(String uid) {
        return this.uploadVideoService.countOnlineVideosForNotUid(uid);
    }

    public List<ItemCard> getOnlineVideosNotMe(String uid, int start, int size) {
        return this.packageVideoCard(this.uploadVideoService.getOnlineVideosForNotUid(uid, start, size));
    }

    public void deleteMyVideos(String uid, List<String> wids) {
        List onlineVideos = this.uploadVideoService.getOnlineVideos(uid, wids);
        if (ArrayMapTools.isNotEmpty((Collection)onlineVideos)) {
            // empty if block
        }
        this.uploadVideoService.deleteVideos(uid, wids);
    }

    private List<ItemCard> packageVideoCard(List<String> wids) {
        if (ArrayMapTools.isEmpty(wids)) {
            return null;
        }
        List videos = this.uploadVideoService.getVideoInfo(wids);
        if (ArrayMapTools.isEmpty((Collection)videos)) {
            return null;
        }
        return videos.stream().map(it -> ItemCard.of(VideoWrapper.of(it))).collect(Collectors.toList());
    }
}

