/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.franchise.service.StudentSchoolContractService;
import com.jz.jar.media.proxy.PlayTitleProxy;
import com.jz.jar.media.proxy.StudentLevelProxy;
import com.jz.jar.media.tool.Global;
import com.jz.jar.media.wrapper.StudentWrapper;
import com.jz.jooq.franchise.tables.pojos.StudentInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentInfoProxy {
    @Autowired
    private StudentInfoService studentInfoService;
    @Autowired
    private StudentSchoolContractService studentSchoolContractService;
    @Autowired
    private PlayTitleProxy playTitleProxy;
    @Autowired
    private StudentLevelProxy studentLevelProxy;

    public List<StudentWrapper> getStudents(String puid) {
        List students = this.studentInfoService.getStudents(puid);
        if (ArrayMapTools.isEmpty((Collection)students)) {
            return null;
        }
        List<String> suids = students.stream().map(it -> it.getSuid()).collect(Collectors.toList());
        Map<String, Integer> suid2Cnt = this.playTitleProxy.getCountDays(puid, suids);
        Map hasLession = this.studentSchoolContractService.getLessionCount(suids);
        ArrayList wrappers = Lists.newArrayList();
        int signCnt = 0;
        for (StudentInfo st : students) {
            signCnt = ArrayMapTools.getIntValue(suid2Cnt, (Object)st.getSuid(), (int)0);
            wrappers.add(this.getWrapper(st, signCnt, (Pair<Integer, Integer>)((Pair)hasLession.get(st.getSuid()))));
        }
        return wrappers;
    }

    public StudentWrapper getStudent(String puid, String suid) {
        StudentInfo st = this.studentInfoService.getStudent(suid);
        if (null == st) {
            return null;
        }
        Pair lessionCount = this.studentSchoolContractService.getLessionCount(st.getSuid());
        return this.getWrapper(st, this.playTitleProxy.getSignCnt(puid, suid), (Pair<Integer, Integer>)lessionCount);
    }

    private String getShowStudentAge(StudentInfo studentInfo) {
        Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(studentInfo.getBirthday());
        StringBuffer sb = new StringBuffer().append(StudentInfoProxy.getAgeContent((Integer)yearOfMonth.getLeft(), "\u5c81"));
        sb.append(StudentInfoProxy.getAgeContent((Integer)yearOfMonth.getRight(), "\u4e2a\u6708"));
        return sb.toString();
    }

    private StudentWrapper getWrapper(StudentInfo st, int signCnt, Pair<Integer, Integer> lessionCount) {
        StudentWrapper student = StudentWrapper.of(st).setAge(this.getShowStudentAge(st)).setLevel(this.studentLevelProxy.getLidForBirthday(st.getBirthday())).setSignCnt(signCnt).setPlayTitle(this.playTitleProxy.getTitle(signCnt)).setQrCode(StudentInfoProxy.getQRCode(st.getSuid()));
        if (null != lessionCount) {
            student.setTotalLession((Integer)lessionCount.getLeft()).setRemainingLession((Integer)lessionCount.getRight());
        } else {
            student.setTotalLession(0).setRemainingLession(0);
        }
        return student;
    }

    private static String getAgeContent(int num, String content) {
        return num <= 0 ? "" : num + content;
    }

    private static String getQRCode(String suid) {
        return "suid=" + suid;
    }
}

