/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.jar.media.service.QuizClassifyService;
import com.jz.jar.media.service.QuizService;
import com.jz.jar.media.service.QuizStudentScoreService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jooq.media.tables.pojos.Quiz;
import com.jz.jooq.media.tables.pojos.QuizStudentScore;
import java.util.Calendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class QuizProxy {
    @Autowired
    private QuizClassifyService quizClassifyService;
    @Autowired
    private QuizService quizService;
    @Autowired
    private QuizStudentScoreService quizStudentScoreService;

    public String getLastWeek() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(3, -1);
        return calendar.get(1) + "" + calendar.get(3);
    }

    public String getCurrentWeek() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + "" + calendar.get(3);
    }

    public Quiz getCurrentWeekQuizForLevel(String lid) {
        String quizId = this.quizClassifyService.getQuizForLidAndWeek(lid, this.getCurrentWeek());
        if (null == quizId) {
            return null;
        }
        Quiz quiz = this.quizService.getQuiz(quizId);
        if (null == quiz) {
            return null;
        }
        AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
        quiz.setZip(OssTools.getInstance((AliyunConfig)aliyunConfig).getUrl(quiz.getZip(), 3600));
        return quiz;
    }

    public void saveCurrentWeekStudentQuizScore(String suid, String qzid, int score, int totalScore) {
        this.quizStudentScoreService.saveStudentScore(suid, this.getCurrentWeek(), qzid, score, totalScore);
    }

    public QuizStudentScore getCurrentWeekStudentScore(String suid) {
        return this.quizStudentScoreService.getStudentScore(suid, this.getCurrentWeek());
    }
}

