package com.jz.jar.media.wrapper;

import com.jz.jooq.franchise.tables.pojos.Lesson;

public class LessonFeedbackWrapper {
	private LessonFeedbackWrapper() {
	}

	private String schoolId;
	private String lessonId;
	private String lessonTitle;
	// 第几节
	private Integer lessonTimes;
	private String content;
	// 上课专心:优秀（Eexcellent）,良好（Good）,一般（Fair）
	private String concentration;
	// 学习态度：优秀（Eexcellent） 良好（Good） 一般（Fair）
	private String attitude;
	// 课堂表现：优秀（Eexcellent） 良好（Good） 一般（Fair）
	private String performance;

	// 是否已请假
	private Boolean isLeave;

	public static LessonFeedbackWrapper of(Lesson lesson) {
		return new LessonFeedbackWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId())
				.setLessonTimes(lesson.getLessonTime());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public LessonFeedbackWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getLessonId() {
		return lessonId;
	}

	public LessonFeedbackWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public LessonFeedbackWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Integer getLessonTimes() {
		return lessonTimes;
	}

	public LessonFeedbackWrapper setLessonTimes(Integer lessonTimes) {
		this.lessonTimes = lessonTimes;
		return this;
	}

	public String getContent() {
		return content;
	}

	public LessonFeedbackWrapper setContent(String content) {
		this.content = content;
		return this;
	}

	public String getConcentration() {
		return concentration;
	}

	public LessonFeedbackWrapper setConcentration(String concentration) {
		this.concentration = concentration;
		return this;
	}

	public String getAttitude() {
		return attitude;
	}

	public LessonFeedbackWrapper setAttitude(String attitude) {
		this.attitude = attitude;
		return this;
	}

	public String getPerformance() {
		return performance;
	}

	public LessonFeedbackWrapper setPerformance(String performance) {
		this.performance = performance;
		return this;
	}

	public Boolean getIsLeave() {
		return isLeave;
	}

	public LessonFeedbackWrapper setIsLeave(Boolean isLeave) {
		this.isLeave = isLeave;
		return this;
	}

}
