/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.media.enums.DbField;
import com.jz.jar.media.proxy.StudentLevelProxy;
import com.jz.jar.media.proxy.StudentPlayProxy;
import com.jz.jar.media.service.CommonPlayHistoryService;
import com.jz.jar.media.service.PlaylistRelationService;
import com.jz.jar.media.service.SpecialPracticeHistoryService;
import com.jz.jooq.media.tables.pojos.Level;
import com.jz.jooq.media.tables.pojos.Playlist;
import com.jz.jooq.media.tables.pojos.Video;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class PlayTaskProxy {
    @Autowired
    private PlaylistRelationService playlistRelationService;
    @Autowired
    private SpecialPracticeHistoryService specialPracticeHistoryService;
    @Autowired
    private CommonPlayHistoryService commonPlayHistoryService;
    @Autowired
    private StudentLevelProxy studentLevelProxy;
    @Autowired
    private StudentPlayProxy studentPlayProxy;

    public void completePlayTask(String uid, String suid, Playlist playlist, Video video, int playLength, String nextWid) {
        Level level = this.studentLevelProxy.getLevelForAge(uid, suid);
        if (null == level) {
            return;
        }
        this.monthPlayTask(uid, suid, playlist, video, playLength, level);
        this.specialPracticePlayTask(suid, playlist, level, playLength, video.getWid(), nextWid);
        this.todayPlayTask(suid, level, playlist, video.getWid(), nextWid, playLength);
    }

    public void lessonCompleteMonthPlayTask(String uid, String suid, Playlist playlist, Video video, int playLength) {
        Level level = this.studentLevelProxy.getLevelForAge(uid, suid);
        if (null == level) {
            return;
        }
        this.monthPlayTask(uid, suid, playlist, video, playLength, level);
    }

    private void monthPlayTask(String uid, String suid, Playlist playlist, Video video, int playLength, Level level) {
        int seconds = playLength == -1 ? video.getDuration() : playLength;
        this.studentPlayProxy.saveStudentMonthPlay(uid, suid, playlist.getPid(), seconds, level);
    }

    private void specialPracticePlayTask(String suid, Playlist playlist, Level level, int playLength, String wid, String nextWid) {
        if (StringTools.isEmptyAndBlank((String)suid) || playLength != -1) {
            return;
        }
        if (!this.playlistRelationService.isSpecialPlaylist(level.getLid(), playlist.getPid())) {
            return;
        }
        String commonkey = this.commonPlayHistoryService.getCommonKey(suid, DbField.special);
        if (this.commonPlayHistoryService.isExist(commonkey, playlist.getPid(), wid)) {
            return;
        }
        this.commonPlayHistoryService.save(commonkey, playlist.getPid(), wid);
        this.specialPracticeHistoryService.saveHistory(suid, playlist.getPid(), playlist.getVideoCnt().intValue(), 1, nextWid);
    }

    private void todayPlayTask(String suid, Level level, Playlist playlist, String wid, String nextWid, int playLength) {
        if (StringTools.isEmptyAndBlank((String)suid) || playLength != -1) {
            return;
        }
        if (!this.studentPlayProxy.isTodayTaskPlaylist(level.getLid(), playlist.getPid())) {
            return;
        }
        String commonkey = this.commonPlayHistoryService.getCommonKey(suid, DbField.everday);
        if (this.commonPlayHistoryService.isExist(commonkey, playlist.getPid(), wid)) {
            return;
        }
        this.commonPlayHistoryService.save(commonkey, playlist.getPid(), wid);
        this.studentPlayProxy.saveStudentTodayPlay(suid, playlist.getPid(), playlist.getVideoCnt(), 1, nextWid);
    }
}

