package com.jz.jar.media.wrapper;

import com.jz.jooq.media.tables.pojos.Playlist;

/**
 * @Title PlaylistWrapper
 * @Package com.jz.playabc.api.wrapper
 * @author tangjunfeng
 * @date 2018年8月2日 下午12:17:11
 * @version V1.0
 */
public class PlaylistWrapper {
	private PlaylistWrapper() {
	}

	private String pid;
	private String name;
	private String pic;
	private Integer videoCnt;
	private Integer difficulty;
	private String remarks;
	private Integer courseId;

	private VideoWrapper video;

	// 完成百分比
	private Integer completePercent;
	// 是否收藏
	private Boolean isCollect;
	// 是否推荐
	private Boolean isRecomm;
	// 是否已完成
	private Boolean isComplete;

	public static PlaylistWrapper of(Playlist playlist) {
		return new PlaylistWrapper().setPid(playlist.getPid()).setName(playlist.getName())
				.setDifficulty(playlist.getDifficulty()).setVideoCnt(playlist.getVideoCnt())
				.setRemarks(playlist.getRemarks()).setCourseId(playlist.getCourseId());
	}

	public String getPid() {
		return pid;
	}

	public PlaylistWrapper setPid(String pid) {
		this.pid = pid;
		return this;
	}

	public String getName() {
		return name;
	}

	public PlaylistWrapper setName(String name) {
		this.name = name;
		return this;
	}

	public String getPic() {
		return pic;
	}

	public PlaylistWrapper setPic(String pic) {
		this.pic = pic;
		return this;
	}

	public Integer getVideoCnt() {
		return videoCnt;
	}

	public PlaylistWrapper setVideoCnt(Integer videoCnt) {
		this.videoCnt = videoCnt;
		return this;
	}

	public Integer getDifficulty() {
		return difficulty;
	}

	public PlaylistWrapper setDifficulty(Integer difficulty) {
		this.difficulty = difficulty;
		return this;
	}

	public String getRemarks() {
		return remarks;
	}

	public PlaylistWrapper setRemarks(String remarks) {
		this.remarks = remarks;
		return this;
	}

	public Integer getCourseId() {
		return courseId;
	}

	public PlaylistWrapper setCourseId(Integer courseId) {
		this.courseId = courseId;
		return this;
	}

	public VideoWrapper getVideo() {
		return video;
	}

	public PlaylistWrapper setVideo(VideoWrapper video) {
		this.video = video;
		return this;
	}

	public Integer getCompletePercent() {
		return completePercent;
	}

	public PlaylistWrapper setCompletePercent(Integer completePercent) {
		this.completePercent = completePercent;
		return this;
	}

	public Boolean getIsCollect() {
		return isCollect;
	}

	public PlaylistWrapper setIsCollect(Boolean isCollect) {
		this.isCollect = isCollect;
		return this;
	}

	public Boolean getIsRecomm() {
		return isRecomm;
	}

	public PlaylistWrapper setIsRecomm(Boolean isRecomm) {
		this.isRecomm = isRecomm;
		return this;
	}

	public Boolean getIsComplete() {
		return isComplete;
	}

	public PlaylistWrapper setIsComplete(Boolean isComplete) {
		this.isComplete = isComplete;
		return this;
	}

}
