package com.jz.jar.media.proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.google.common.collect.Maps;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.FUserInfoService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jar.media.wrapper.TeacherWrapper;
import com.jz.jooq.franchise.tables.pojos.FuserInfo;

/**
 * @Title TeacherProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月21日 下午5:49:17
 * @version V1.0
 */
@Lazy
@Service
public class TeacherProxy {

	@Autowired
	private FUserInfoService teacherService;

	public Map<String, TeacherWrapper> getTeachers(Collection<String> tids) {
		List<FuserInfo> teachers = teacherService.getTeachers(tids);
		if (ArrayMapTools.isEmpty(teachers))
			return Maps.newHashMap();
		Map<String, TeacherWrapper> tid2Teacher = Maps.newHashMap();
		teachers.forEach(it -> {
			tid2Teacher.put(it.getUid(), TeacherWrapper.of(it).setPic(AliyunBean.getImagesUrl(it.getPicAddress())));
		});
		return tid2Teacher;
	}
}
