package com.jz.jar.media.proxy;

import java.util.Calendar;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.aliyun.beans.AliyunConfig;
import com.jz.aliyun.tools.OssTools;
import com.jz.jar.media.service.QuizClassifyService;
import com.jz.jar.media.service.QuizService;
import com.jz.jar.media.service.QuizStudentScoreService;
import com.jz.jar.media.tool.AliyunBean;
import com.jz.jooq.media.tables.pojos.Quiz;
import com.jz.jooq.media.tables.pojos.QuizStudentScore;

/**
 * @Title QuizProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月16日 下午5:12:17
 * @version V1.0
 */
@Lazy
@Service
public class QuizProxy {

	@Autowired
	private QuizClassifyService quizClassifyService;
	@Autowired
	private QuizService quizService;
	@Autowired
	private QuizStudentScoreService quizStudentScoreService;
	
	public String getLastWeek() {
		Calendar calendar = Calendar.getInstance();
		calendar.add(Calendar.WEEK_OF_YEAR, -1);
		return calendar.get(Calendar.YEAR) + "" + calendar.get(Calendar.WEEK_OF_YEAR);
	}
	
	public String getCurrentWeek() {
		Calendar calendar = Calendar.getInstance();
		return calendar.get(Calendar.YEAR) + "" + calendar.get(Calendar.WEEK_OF_YEAR);
	}

	/** 获取本周的试卷 */
	public Quiz getCurrentWeekQuizForLevel(String lid) {
		String quizId = quizClassifyService.getQuizForLidAndWeek(lid, getCurrentWeek());
		if (null == quizId)
			return null;
		Quiz quiz = quizService.getQuiz(quizId);
		if (null == quiz)
			return null;
		AliyunConfig aliyunConfig = AliyunBean.getMediaAliyunConfig();
		quiz.setZip(OssTools.getInstance(aliyunConfig).getUrl(quiz.getZip(), 3600));
		return quiz;
	}
	
	/** 保存学员本周的考试成绩 */
	public void saveCurrentWeekStudentQuizScore(String suid, String qzid, int score, int totalScore) {
		quizStudentScoreService.saveStudentScore(suid, getCurrentWeek(), qzid, score, totalScore);
	}
	
	/** 获取本周的考试成绩 */
	public QuizStudentScore getCurrentWeekStudentScore(String suid) {
		return quizStudentScoreService.getStudentScore(suid, getCurrentWeek());
	}
}
