package com.jz.jar.media.proxy;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.media.common.ItemCard;
import com.jz.jar.media.enums.UploadVideoStatus;
import com.jz.jar.media.service.UploadVideoService;
import com.jz.jar.media.wrapper.VideoWrapper;
import com.jz.jooq.media.tables.pojos.UploadVideo;

/**
 * @Title UploadVideoProxy
 * @Package com.jz.jar.media.proxy
 * @author tangjunfeng
 * @date 2018年8月20日 下午4:24:43
 * @version V1.0
 */
@Lazy
@Service
public class UploadVideoProxy {

	@Autowired
	private UploadVideoService uploadVideoService;

	/** 是否学员上传的视频 */
	private boolean isStudentUploadVideo(String wid) {
		// oss.oss_identity_config.prefix
		return wid.startsWith("sv_");
	}
	
	/** 将当前视频保存至待转码状态 */
	public void saveToWaiting(String wid, String uid, String name) {
		if (isStudentUploadVideo(wid)) {
			uploadVideoService.saveToWaiting(wid, uid, name);
		}
	}
	
	/* 获取我上传的所有的视频 */
	private List<UploadVideoStatus> getStatus() {
		return Arrays.asList(UploadVideoStatus.online, UploadVideoStatus.wating, UploadVideoStatus.verifying,
				UploadVideoStatus.notPassed);
	}
	
	public int countMyVideos(String uid) {
		return uploadVideoService.countVideos(uid, getStatus());
	}
	
	public List<ItemCard> getMyVideos(String uid, int start, int size) {
		return packageVideoCard(uploadVideoService.getVideos(uid, getStatus(), start, size));
	}
	
	/* 获取所有的在线视频，但是不包含自己 */
	public int countOnlineVideosNotMe(String uid) {
		return uploadVideoService.countOnlineVideosForNotUid(uid);
	}
	
	public List<ItemCard> getOnlineVideosNotMe(String uid, int start, int size) {
		return packageVideoCard(uploadVideoService.getOnlineVideosForNotUid(uid, start, size));
	}
	
	/** 删除我上传的视频 */
	public void deleteMyVideos(String uid, List<String> wids) {
		List<String> onlineVideos = uploadVideoService.getOnlineVideos(uid, wids);
		if (ArrayMapTools.isNotEmpty(onlineVideos)) {
			// 如果上线后的视频需要写入到video表中，则将video表中的数据删除
		}
		uploadVideoService.deleteVideos(uid, wids);
	}
	
	/** 将当前视频信息包装成卡片信息 */
	private List<ItemCard> packageVideoCard(List<String> wids) {
		if (ArrayMapTools.isEmpty(wids))
			return null;
		List<UploadVideo> videos = uploadVideoService.getVideoInfo(wids);
		if (ArrayMapTools.isEmpty(videos))
			return null;
		return videos.stream().map(it -> ItemCard.of(VideoWrapper.of(it))).collect(Collectors.toList());
	}
}
