package com.jz.jar.media.wrapper;

import java.util.List;

import com.jz.jar.media.common.StudentClassStatus;
import com.jz.jooq.franchise.tables.pojos.Lesson;

/**
 * @Title LessonWrapper
 * @Package com.jz.jar.media.wrapper
 * @author tangjunfeng
 * @date 2018年8月21日 下午5:29:01
 * @version V1.0
 */
public class LessonWrapper {
	private LessonWrapper() {
	}

	private String schoolId;
	private String lessonId;
	// 第几节
	private Integer lessonTimes;
	private String lessonTitle;
	private Long startTime;
	private Long endTime;
	// 上课的状态
	private String classStatus;
	// 教室
	private String classroom;
	// 学员的上课状态
	private List<StudentClassStatus> studentClassStatus;

	private TeacherWrapper teacher;

	public static LessonWrapper of(Lesson lesson) {
		return new LessonWrapper().setSchoolId(lesson.getSchoolId()).setLessonId(lesson.getLessonId())
				.setLessonTimes(lesson.getLessonTime()).setLessonTitle(lesson.getContent())
				.setStartTime(lesson.getStartTime()).setEndTime(lesson.getEndTime());
	}

	public String getSchoolId() {
		return schoolId;
	}

	public LessonWrapper setSchoolId(String schoolId) {
		this.schoolId = schoolId;
		return this;
	}

	public String getLessonId() {
		return lessonId;
	}

	public LessonWrapper setLessonId(String lessonId) {
		this.lessonId = lessonId;
		return this;
	}

	public Integer getLessonTimes() {
		return lessonTimes;
	}

	public LessonWrapper setLessonTimes(Integer lessonTimes) {
		this.lessonTimes = lessonTimes;
		return this;
	}

	public String getLessonTitle() {
		return lessonTitle;
	}

	public LessonWrapper setLessonTitle(String lessonTitle) {
		this.lessonTitle = lessonTitle;
		return this;
	}

	public Long getStartTime() {
		return startTime;
	}

	public LessonWrapper setStartTime(Long startTime) {
		this.startTime = startTime;
		return this;
	}

	public Long getEndTime() {
		return endTime;
	}

	public LessonWrapper setEndTime(Long endTime) {
		this.endTime = endTime;
		return this;
	}

	public String getClassStatus() {
		return classStatus;
	}

	public LessonWrapper setClassStatus(String classStatus) {
		this.classStatus = classStatus;
		return this;
	}

	public String getClassroom() {
		return classroom;
	}

	public LessonWrapper setClassroom(String classroom) {
		this.classroom = classroom;
		return this;
	}

	public List<StudentClassStatus> getStudentClassStatus() {
		return studentClassStatus;
	}

	public LessonWrapper setStudentClassStatus(List<StudentClassStatus> studentClassStatus) {
		this.studentClassStatus = studentClassStatus;
		return this;
	}

	public TeacherWrapper getTeacher() {
		return teacher;
	}

	public LessonWrapper setTeacher(TeacherWrapper teacher) {
		this.teacher = teacher;
		return this;
	}

}
