/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jz.common.utils.collection.ArrayMapTools;
import com.jz.jar.franchise.service.ClassroomService;
import com.jz.jar.franchise.service.CourseHoLessonService;
import com.jz.jar.franchise.service.FestivalAvoidService;
import com.jz.jar.franchise.service.LessonService;
import com.jz.jar.franchise.service.LessonStudentService;
import com.jz.jar.franchise.service.ManageSettingService;
import com.jz.jar.media.common.DbEnums;
import com.jz.jar.media.common.StudentClassStatus;
import com.jz.jar.media.proxy.TeacherProxy;
import com.jz.jar.media.wrapper.LessonWrapper;
import com.jz.jar.media.wrapper.TeacherWrapper;
import com.jz.jooq.franchise.tables.pojos.Lesson;
import com.jz.jooq.franchise.tables.pojos.LessonStudent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class LessonProxy {
    private static final SimpleDateFormat simple = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private LessonStudentService lessonStudentService;
    @Autowired
    private LessonService lessonService;
    @Autowired
    private ClassroomService classroomService;
    @Autowired
    private FestivalAvoidService festivalAvoidService;
    @Autowired
    private CourseHoLessonService courseHoLessonService;
    @Autowired
    private ManageSettingService manageSettingService;
    @Autowired
    private TeacherProxy teacherProxy;

    public Pair<List<LessonWrapper>, String> getTimetables(String suid, long startTime, long endTime) {
        List lessonStudent = this.lessonStudentService.findAllLessonForStudent(suid);
        if (ArrayMapTools.isEmpty((Collection)lessonStudent)) {
            return null;
        }
        HashMap schoolLessonStudent = Maps.newHashMap();
        HashMap school2Lessons = Maps.newHashMap();
        lessonStudent.forEach(it -> {
            if (!school2Lessons.containsKey(it.getSchoolId())) {
                school2Lessons.put(it.getSchoolId(), Lists.newArrayList());
            }
            ((List)school2Lessons.get(it.getSchoolId())).add(it.getLessonId());
            schoolLessonStudent.put(this.tKey(it.getSchoolId(), it.getLessonId()), it);
        });
        List lessons = this.lessonService.findLession((Map)school2Lessons, startTime, endTime);
        if (ArrayMapTools.isEmpty((Collection)lessons)) {
            String st = simple.format(new Date(startTime));
            String et = simple.format(new Date(endTime));
            List holiday = this.festivalAvoidService.getHoliday(school2Lessons.keySet(), st, et);
            if (ArrayMapTools.isEmpty((Collection)holiday)) {
                return null;
            }
            return Pair.of(null, holiday.get(0));
        }
        ArrayList wrappers = Lists.newArrayList();
        HashMap s2crGet = Maps.newHashMap();
        HashMap s2crPackage = Maps.newHashMap();
        HashMap teacherHas = Maps.newHashMap();
        HashMap flGet = Maps.newHashMap();
        HashMap flPackage = Maps.newHashMap();
        HashMap s2clsGet = Maps.newHashMap();
        HashMap s2clsPackage = Maps.newHashMap();
        long timeMillis = System.currentTimeMillis();
        lessons.forEach(it -> {
            LessonWrapper wrapper = LessonWrapper.of(it);
            if (it.getCourseId() > 0) {
                this.putArray(flGet, it.getCourseId(), it.getLessonTime(), true);
                this.putArray(flPackage, this.tKey(it.getCourseId(), it.getLessonTime()), wrapper, false);
                if (it.getStartTime() > timeMillis) {
                    this.putArray(s2clsGet, it.getSchoolId(), it.getCid(), true);
                    this.putArray(s2clsPackage, this.tKey(it.getSchoolId(), it.getCid()), wrapper, false);
                }
            }
            this.putArray(teacherHas, it.getTeacher(), wrapper, false);
            this.putArray(s2crGet, it.getSchoolId(), it.getClassroomId(), true);
            this.putArray(s2crPackage, this.tKey(it.getSchoolId(), it.getClassroomId()), wrapper, false);
            this.setClassStatus(timeMillis, (Lesson)it, wrapper);
            this.setStudentLessonStatus((LessonStudent)schoolLessonStudent.get(this.tKey(it.getSchoolId(), it.getLessonId())), wrapper);
            wrappers.add(wrapper);
        });
        this.packageClassroom(s2crGet, s2crPackage);
        this.packageTeacher(teacherHas);
        this.packageFormalLesson(flGet, flPackage);
        return Pair.of((Object)wrappers, null);
    }

    private String tKey(Object arg0, Object arg1) {
        return arg0 + ":" + arg1;
    }

    private <K, V> void putArray(Map<K, Collection<V>> map, K key, V val, boolean isSet) {
        if (!map.containsKey(key)) {
            map.put(key, isSet ? Sets.newHashSet() : Lists.newArrayList());
        }
        map.get(key).add(val);
    }

    private void setClassStatus(long timeMillis, Lesson lesson, LessonWrapper wrapper) {
        if (lesson.getStartTime() > timeMillis) {
            wrapper.setClassStatus("\u5373\u5c06\u5f00\u59cb");
            return;
        }
        if (lesson.getEndTime() < timeMillis) {
            wrapper.setClassStatus("\u5df2\u5b8c\u7ed3");
            return;
        }
        wrapper.setClassStatus("\u5b66\u4e60\u4e2d");
    }

    private void setStudentLessonStatus(LessonStudent lessonStudent, LessonWrapper lesson) {
        if (null == lessonStudent) {
            return;
        }
        switch (lessonStudent.getStatus()) {
            case 0: {
                lesson.setStudentClassStatus(Arrays.asList(StudentClassStatus.prepare, StudentClassStatus.leave));
                break;
            }
            case 1: 
            case 2: {
                lesson.setStudentClassStatus(Arrays.asList(StudentClassStatus.review));
            }
            default: {
                lesson.setStudentClassStatus(Arrays.asList(StudentClassStatus.makeup));
            }
        }
    }

    private void packageTeacher(Map<String, Collection<LessonWrapper>> teacherHas) {
        Map<String, TeacherWrapper> teachers = this.teacherProxy.getTeachers(teacherHas.keySet());
        if (ArrayMapTools.isEmpty(teachers)) {
            return;
        }
        teachers.forEach((id, t) -> {
            if (teacherHas.containsKey(id)) {
                ((Collection)teacherHas.get(id)).forEach(w -> w.setTeacher((TeacherWrapper)t));
            }
        });
    }

    private void packageClassroom(Map<String, Collection<Integer>> s2crGet, Map<String, Collection<LessonWrapper>> s2crPackage) {
        List classrooms = this.classroomService.findClassrooms(s2crGet);
        if (ArrayMapTools.isEmpty((Collection)classrooms)) {
            return;
        }
        classrooms.forEach(it -> {
            String key = this.tKey(it.getSchoolId(), it.getClassroomId());
            if (s2crPackage.containsKey(key)) {
                ((Collection)s2crPackage.get(key)).forEach(ws -> ws.setClassroom(it.getName()));
            }
        });
    }

    private void packageFormalLesson(Map<Integer, Collection<Integer>> flGet, Map<String, Collection<LessonWrapper>> flPackage) {
        List hoLession = this.courseHoLessonService.findHoLession(DbEnums.playabc.name(), flGet);
        if (ArrayMapTools.isEmpty((Collection)hoLession)) {
            return;
        }
        hoLession.forEach(it -> {
            String key = this.tKey(it.getCourseId(), it.getLessonTime());
            if (flPackage.containsKey(key)) {
                ((Collection)flPackage.get(key)).forEach(ws -> ws.setLessonTitle(it.getLessonTitle()));
            }
        });
    }

    private Map<String, Integer> getLeaveNum(Collection<String> schools) {
        List leaveNum = this.manageSettingService.getLeaveNum(schools);
        if (ArrayMapTools.isEmpty((Collection)leaveNum)) {
            return Maps.newHashMap();
        }
        return leaveNum.stream().collect(Collectors.toMap(it -> it.getSchoolId(), it -> it.getLeaveMaxNum()));
    }
}

