/*
 * Decompiled with CFR 0.152.
 */
package com.jz.jar.media.proxy;

import com.jz.common.utils.text.StringTools;
import com.jz.jar.franchise.service.StudentInfoService;
import com.jz.jar.media.proxy.LevelProxy;
import com.jz.jar.media.tool.Global;
import com.jz.jooq.media.tables.pojos.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class StudentLevelProxy {
    @Autowired
    private LevelProxy levelProxy;
    @Autowired
    private StudentInfoService studentInfoService;

    public Level getLevelForAge(String puid, String suid) {
        if (!StringTools.allNotEmptyAndBlank((String[])new String[]{puid, suid})) {
            return null;
        }
        String birthday = this.studentInfoService.getStudentBirthday(puid, suid);
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(birthday);
        float age = (float)((Integer)yearOfMonth.getLeft()).intValue() * Float.parseFloat("1." + ((Integer)yearOfMonth.getRight()).toString());
        return this.levelProxy.getLevelForAge(age);
    }

    public String getLidForBirthday(String birthday) {
        if (StringTools.isEmptyAndBlank((String)birthday)) {
            return null;
        }
        Pair<Integer, Integer> yearOfMonth = Global.getAgeMonth(birthday);
        float age = (float)((Integer)yearOfMonth.getLeft()).intValue() * Float.parseFloat("1." + ((Integer)yearOfMonth.getRight()).toString());
        return this.levelProxy.getLevelForAge(age).getLid();
    }
}

